/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.iothub.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.iothub.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.iothub.implementation.IotHubClientImpl;
import com.azure.resourcemanager.iothub.models.ErrorDetailsException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PrivateEndpointConnectionsClientImpl
implements PrivateEndpointConnectionsClient {
    private final PrivateEndpointConnectionsService service;
    private final IotHubClientImpl client;

    PrivateEndpointConnectionsClientImpl(IotHubClientImpl client) {
        this.service = (PrivateEndpointConnectionsService)RestProxy.create(PrivateEndpointConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<PrivateEndpointConnectionInner>>> listWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<PrivateEndpointConnectionInner>>> listWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<List<PrivateEndpointConnectionInner>> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<PrivateEndpointConnectionInner>> listWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<PrivateEndpointConnectionInner> list(String resourceGroupName, String resourceName) {
        return (List)this.listWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateEndpointConnectionInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateEndpointConnectionInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> getAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PrivateEndpointConnectionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateEndpointConnectionInner> getWithResponse(String resourceGroupName, String resourceName, String privateEndpointConnectionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner get(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        return (PrivateEndpointConnectionInner)((Object)this.getWithResponse(resourceGroupName, resourceName, privateEndpointConnectionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (privateEndpointConnection == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnection is required and cannot be null."));
        }
        privateEndpointConnection.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (privateEndpointConnection == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnection is required and cannot be null."));
        }
        privateEndpointConnection.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginUpdate(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return this.beginUpdateAsync(resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginUpdate(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, Context context) {
        return this.beginUpdateAsync(resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return this.beginUpdateAsync(resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, Context context) {
        return this.beginUpdateAsync(resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner update(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return (PrivateEndpointConnectionInner)((Object)this.updateAsync(resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner update(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, Context context) {
        return (PrivateEndpointConnectionInner)((Object)this.updateAsync(resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginDeleteAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginDeleteAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginDelete(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, privateEndpointConnectionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginDelete(String resourceGroupName, String resourceName, String privateEndpointConnectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, privateEndpointConnectionName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> deleteAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, privateEndpointConnectionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> deleteAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, privateEndpointConnectionName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner delete(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        return (PrivateEndpointConnectionInner)((Object)this.deleteAsync(resourceGroupName, resourceName, privateEndpointConnectionName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner delete(String resourceGroupName, String resourceName, String privateEndpointConnectionName, Context context) {
        return (PrivateEndpointConnectionInner)((Object)this.deleteAsync(resourceGroupName, resourceName, privateEndpointConnectionName, context).block());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="IotHubClientPrivateE")
    public static interface PrivateEndpointConnectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/iotHubs/{resourceName}/privateEndpointConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<List<PrivateEndpointConnectionInner>>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/iotHubs/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<PrivateEndpointConnectionInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/iotHubs/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @BodyParam(value="application/json") PrivateEndpointConnectionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/iotHubs/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

