/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iothub.models.AuthenticationType;
import com.azure.resourcemanager.iothub.models.ManagedIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

public final class StorageEndpointProperties {
    @JsonProperty(value="sasTtlAsIso8601")
    private Duration sasTtlAsIso8601;
    @JsonProperty(value="connectionString", required=true)
    private String connectionString;
    @JsonProperty(value="containerName", required=true)
    private String containerName;
    @JsonProperty(value="authenticationType")
    private AuthenticationType authenticationType;
    @JsonProperty(value="identity")
    private ManagedIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(StorageEndpointProperties.class);

    public Duration sasTtlAsIso8601() {
        return this.sasTtlAsIso8601;
    }

    public StorageEndpointProperties withSasTtlAsIso8601(Duration sasTtlAsIso8601) {
        this.sasTtlAsIso8601 = sasTtlAsIso8601;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public StorageEndpointProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String containerName() {
        return this.containerName;
    }

    public StorageEndpointProperties withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public StorageEndpointProperties withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public ManagedIdentity identity() {
        return this.identity;
    }

    public StorageEndpointProperties withIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.connectionString() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property connectionString in model StorageEndpointProperties"));
        }
        if (this.containerName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property containerName in model StorageEndpointProperties"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

