/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iothub.models.RouteProperties;
import com.azure.resourcemanager.iothub.models.RoutingMessage;
import com.azure.resourcemanager.iothub.models.RoutingTwin;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class TestRouteInput {
    @JsonProperty(value="message")
    private RoutingMessage message;
    @JsonProperty(value="route", required=true)
    private RouteProperties route;
    @JsonProperty(value="twin")
    private RoutingTwin twin;
    private static final ClientLogger LOGGER = new ClientLogger(TestRouteInput.class);

    public RoutingMessage message() {
        return this.message;
    }

    public TestRouteInput withMessage(RoutingMessage message) {
        this.message = message;
        return this;
    }

    public RouteProperties route() {
        return this.route;
    }

    public TestRouteInput withRoute(RouteProperties route) {
        this.route = route;
        return this;
    }

    public RoutingTwin twin() {
        return this.twin;
    }

    public TestRouteInput withTwin(RoutingTwin twin) {
        this.twin = twin;
        return this;
    }

    public void validate() {
        if (this.message() != null) {
            this.message().validate();
        }
        if (this.route() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property route in model TestRouteInput"));
        }
        this.route().validate();
        if (this.twin() != null) {
            this.twin().validate();
        }
    }
}

