/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.LinkedServiceInner;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.LinkedService;
import com.azure.resourcemanager.loganalytics.models.LinkedServiceEntityStatus;
import java.util.Collections;
import java.util.Map;

public final class LinkedServiceImpl
implements LinkedService,
LinkedService.Definition,
LinkedService.Update {
    private LinkedServiceInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private String linkedServiceName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String resourceId() {
        return this.innerModel().resourceId();
    }

    @Override
    public String writeAccessResourceId() {
        return this.innerModel().writeAccessResourceId();
    }

    @Override
    public LinkedServiceEntityStatus provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public LinkedServiceInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public LinkedServiceImpl withExistingWorkspace(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public LinkedService create() {
        this.innerObject = this.serviceManager.serviceClient().getLinkedServices().createOrUpdate(this.resourceGroupName, this.workspaceName, this.linkedServiceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public LinkedService create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getLinkedServices().createOrUpdate(this.resourceGroupName, this.workspaceName, this.linkedServiceName, this.innerModel(), context);
        return this;
    }

    LinkedServiceImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new LinkedServiceInner();
        this.serviceManager = serviceManager;
        this.linkedServiceName = name;
    }

    @Override
    public LinkedServiceImpl update() {
        return this;
    }

    @Override
    public LinkedService apply() {
        this.innerObject = this.serviceManager.serviceClient().getLinkedServices().createOrUpdate(this.resourceGroupName, this.workspaceName, this.linkedServiceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public LinkedService apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getLinkedServices().createOrUpdate(this.resourceGroupName, this.workspaceName, this.linkedServiceName, this.innerModel(), context);
        return this;
    }

    LinkedServiceImpl(LinkedServiceInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.workspaceName = Utils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.linkedServiceName = Utils.getValueFromIdByName(innerObject.id(), "linkedServices");
    }

    @Override
    public LinkedService refresh() {
        this.innerObject = (LinkedServiceInner)((Object)this.serviceManager.serviceClient().getLinkedServices().getWithResponse(this.resourceGroupName, this.workspaceName, this.linkedServiceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public LinkedService refresh(Context context) {
        this.innerObject = (LinkedServiceInner)((Object)this.serviceManager.serviceClient().getLinkedServices().getWithResponse(this.resourceGroupName, this.workspaceName, this.linkedServiceName, context).getValue());
        return this;
    }

    @Override
    public LinkedServiceImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    @Override
    public LinkedServiceImpl withResourceId(String resourceId) {
        this.innerModel().withResourceId(resourceId);
        return this;
    }

    @Override
    public LinkedServiceImpl withWriteAccessResourceId(String writeAccessResourceId) {
        this.innerModel().withWriteAccessResourceId(writeAccessResourceId);
        return this;
    }

    @Override
    public LinkedServiceImpl withProvisioningState(LinkedServiceEntityStatus provisioningState) {
        this.innerModel().withProvisioningState(provisioningState);
        return this;
    }
}

