/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.OperationStatusesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.OperationStatusInner;
import com.azure.resourcemanager.loganalytics.implementation.OperationStatusImpl;
import com.azure.resourcemanager.loganalytics.models.OperationStatus;
import com.azure.resourcemanager.loganalytics.models.OperationStatuses;

public final class OperationStatusesImpl
implements OperationStatuses {
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusesImpl.class);
    private final OperationStatusesClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public OperationStatusesImpl(OperationStatusesClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationStatus> getWithResponse(String location, String asyncOperationId, Context context) {
        Response<OperationStatusInner> inner = this.serviceClient().getWithResponse(location, asyncOperationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationStatusImpl((OperationStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationStatus get(String location, String asyncOperationId) {
        OperationStatusInner inner = this.serviceClient().get(location, asyncOperationId);
        if (inner != null) {
            return new OperationStatusImpl(inner, this.manager());
        }
        return null;
    }

    private OperationStatusesClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}

