/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.loganalytics.fluent.WorkspacePurgesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.WorkspacePurgeResponseInner;
import com.azure.resourcemanager.loganalytics.fluent.models.WorkspacePurgeStatusResponseInner;
import com.azure.resourcemanager.loganalytics.implementation.OperationalInsightsManagementClientImpl;
import com.azure.resourcemanager.loganalytics.models.WorkspacePurgeBody;
import com.azure.resourcemanager.loganalytics.models.WorkspacePurgesPurgeResponse;
import reactor.core.publisher.Mono;

public final class WorkspacePurgesClientImpl
implements WorkspacePurgesClient {
    private final WorkspacePurgesService service;
    private final OperationalInsightsManagementClientImpl client;

    WorkspacePurgesClientImpl(OperationalInsightsManagementClientImpl client) {
        this.service = (WorkspacePurgesService)RestProxy.create(WorkspacePurgesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspacePurgesPurgeResponse> purgeWithResponseAsync(String resourceGroupName, String workspaceName, WorkspacePurgeBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.purge(this.client.getEndpoint(), resourceGroupName, "2020-08-01", this.client.getSubscriptionId(), workspaceName, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspacePurgesPurgeResponse> purgeWithResponseAsync(String resourceGroupName, String workspaceName, WorkspacePurgeBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.purge(this.client.getEndpoint(), resourceGroupName, "2020-08-01", this.client.getSubscriptionId(), workspaceName, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspacePurgeResponseInner> purgeAsync(String resourceGroupName, String workspaceName, WorkspacePurgeBody body) {
        return this.purgeWithResponseAsync(resourceGroupName, workspaceName, body).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspacePurgesPurgeResponse purgeWithResponse(String resourceGroupName, String workspaceName, WorkspacePurgeBody body, Context context) {
        return (WorkspacePurgesPurgeResponse)((Object)this.purgeWithResponseAsync(resourceGroupName, workspaceName, body, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspacePurgeResponseInner purge(String resourceGroupName, String workspaceName, WorkspacePurgeBody body) {
        return this.purgeWithResponse(resourceGroupName, workspaceName, body, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkspacePurgeStatusResponseInner>> getPurgeStatusWithResponseAsync(String resourceGroupName, String workspaceName, String purgeId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (purgeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter purgeId is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPurgeStatus(this.client.getEndpoint(), resourceGroupName, "2020-08-01", this.client.getSubscriptionId(), workspaceName, purgeId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkspacePurgeStatusResponseInner>> getPurgeStatusWithResponseAsync(String resourceGroupName, String workspaceName, String purgeId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (purgeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter purgeId is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPurgeStatus(this.client.getEndpoint(), resourceGroupName, "2020-08-01", this.client.getSubscriptionId(), workspaceName, purgeId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkspacePurgeStatusResponseInner> getPurgeStatusAsync(String resourceGroupName, String workspaceName, String purgeId) {
        return this.getPurgeStatusWithResponseAsync(resourceGroupName, workspaceName, purgeId).flatMap(res -> Mono.justOrEmpty((Object)((WorkspacePurgeStatusResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkspacePurgeStatusResponseInner> getPurgeStatusWithResponse(String resourceGroupName, String workspaceName, String purgeId, Context context) {
        return (Response)this.getPurgeStatusWithResponseAsync(resourceGroupName, workspaceName, purgeId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkspacePurgeStatusResponseInner getPurgeStatus(String resourceGroupName, String workspaceName, String purgeId) {
        return (WorkspacePurgeStatusResponseInner)this.getPurgeStatusWithResponse(resourceGroupName, workspaceName, purgeId, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="OperationalInsightsM")
    public static interface WorkspacePurgesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/purge")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<WorkspacePurgesPurgeResponse> purge(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="workspaceName") String var5, @BodyParam(value="application/json") WorkspacePurgeBody var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/operations/{purgeId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkspacePurgeStatusResponseInner>> getPurgeStatus(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="purgeId") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

