/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.resourcemanager.monitor.models.ConditionFailingPeriods;
import com.azure.resourcemanager.monitor.models.ConditionOperator;
import com.azure.resourcemanager.monitor.models.Dimension;
import com.azure.resourcemanager.monitor.models.TimeAggregation;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Condition {
    @JsonProperty(value="query")
    private String query;
    @JsonProperty(value="timeAggregation")
    private TimeAggregation timeAggregation;
    @JsonProperty(value="metricMeasureColumn")
    private String metricMeasureColumn;
    @JsonProperty(value="resourceIdColumn")
    private String resourceIdColumn;
    @JsonProperty(value="dimensions")
    private List<Dimension> dimensions;
    @JsonProperty(value="operator")
    private ConditionOperator operator;
    @JsonProperty(value="threshold")
    private Double threshold;
    @JsonProperty(value="failingPeriods")
    private ConditionFailingPeriods failingPeriods;
    @JsonProperty(value="metricName")
    private String metricName;

    public String query() {
        return this.query;
    }

    public Condition withQuery(String query) {
        this.query = query;
        return this;
    }

    public TimeAggregation timeAggregation() {
        return this.timeAggregation;
    }

    public Condition withTimeAggregation(TimeAggregation timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    public String metricMeasureColumn() {
        return this.metricMeasureColumn;
    }

    public Condition withMetricMeasureColumn(String metricMeasureColumn) {
        this.metricMeasureColumn = metricMeasureColumn;
        return this;
    }

    public String resourceIdColumn() {
        return this.resourceIdColumn;
    }

    public Condition withResourceIdColumn(String resourceIdColumn) {
        this.resourceIdColumn = resourceIdColumn;
        return this;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Condition withDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public ConditionOperator operator() {
        return this.operator;
    }

    public Condition withOperator(ConditionOperator operator) {
        this.operator = operator;
        return this;
    }

    public Double threshold() {
        return this.threshold;
    }

    public Condition withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public ConditionFailingPeriods failingPeriods() {
        return this.failingPeriods;
    }

    public Condition withFailingPeriods(ConditionFailingPeriods failingPeriods) {
        this.failingPeriods = failingPeriods;
        return this;
    }

    public String metricName() {
        return this.metricName;
    }

    public Condition withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public void validate() {
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
        if (this.failingPeriods() != null) {
            this.failingPeriods().validate();
        }
    }
}

