/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.fluent.models.ApplicationGatewaySslCertificateInner;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslCertificate;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;

class ApplicationGatewaySslCertificateImpl
extends ChildResourceImpl<ApplicationGatewaySslCertificateInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewaySslCertificate,
ApplicationGatewaySslCertificate.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewaySslCertificate.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewaySslCertificate.Update {
    ApplicationGatewaySslCertificateImpl(ApplicationGatewaySslCertificateInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((ApplicationGatewaySslCertificateInner)((Object)this.innerModel())).name();
    }

    @Override
    public String publicData() {
        return ((ApplicationGatewaySslCertificateInner)((Object)this.innerModel())).publicCertData();
    }

    @Override
    public String keyVaultSecretId() {
        return ((ApplicationGatewaySslCertificateInner)((Object)this.innerModel())).keyVaultSecretId();
    }

    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withSslCertificate(this);
    }

    public ApplicationGatewaySslCertificateImpl withPfxFromBytes(byte[] pfxData) {
        String encoded = new String(Base64.getEncoder().encode(pfxData), StandardCharsets.UTF_8);
        ((ApplicationGatewaySslCertificateInner)((Object)this.innerModel())).withData(encoded);
        return this;
    }

    public ApplicationGatewaySslCertificateImpl withPfxFromFile(File pfxFile) throws IOException {
        if (pfxFile == null) {
            return null;
        }
        byte[] content = Files.readAllBytes(pfxFile.toPath());
        return this.withPfxFromBytes(content);
    }

    public ApplicationGatewaySslCertificateImpl withPfxPassword(String password) {
        ((ApplicationGatewaySslCertificateInner)((Object)this.innerModel())).withPassword(password);
        return this;
    }

    public ApplicationGatewaySslCertificateImpl withKeyVaultSecretId(String keyVaultSecretId) {
        ((ApplicationGatewaySslCertificateInner)((Object)this.innerModel())).withKeyVaultSecretId(keyVaultSecretId);
        return this;
    }
}

