/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resourcegraph.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resourcegraph.ResourceGraphManager;
import com.azure.resourcemanager.resourcegraph.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.resourcegraph.fluent.models.QueryResponseInner;
import com.azure.resourcemanager.resourcegraph.implementation.QueryResponseImpl;
import com.azure.resourcemanager.resourcegraph.models.QueryRequest;
import com.azure.resourcemanager.resourcegraph.models.QueryResponse;
import com.azure.resourcemanager.resourcegraph.models.ResourceProviders;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final ResourceGraphManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, ResourceGraphManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<QueryResponse> resourcesWithResponse(QueryRequest query, Context context) {
        Response<QueryResponseInner> inner = this.serviceClient().resourcesWithResponse(query, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new QueryResponseImpl((QueryResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public QueryResponse resources(QueryRequest query) {
        QueryResponseInner inner = this.serviceClient().resources(query);
        if (inner != null) {
            return new QueryResponseImpl(inner, this.manager());
        }
        return null;
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private ResourceGraphManager manager() {
        return this.serviceManager;
    }
}

