/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.fluent.SecurityCenter;
import com.azure.resourcemanager.security.implementation.AdaptiveApplicationControlsImpl;
import com.azure.resourcemanager.security.implementation.AdaptiveNetworkHardeningsImpl;
import com.azure.resourcemanager.security.implementation.AdvancedThreatProtectionsImpl;
import com.azure.resourcemanager.security.implementation.AlertsImpl;
import com.azure.resourcemanager.security.implementation.AlertsSuppressionRulesImpl;
import com.azure.resourcemanager.security.implementation.AllowedConnectionsImpl;
import com.azure.resourcemanager.security.implementation.ApiCollectionsImpl;
import com.azure.resourcemanager.security.implementation.ApplicationOperationsImpl;
import com.azure.resourcemanager.security.implementation.ApplicationsImpl;
import com.azure.resourcemanager.security.implementation.AssessmentsImpl;
import com.azure.resourcemanager.security.implementation.AssessmentsMetadatasImpl;
import com.azure.resourcemanager.security.implementation.AutoProvisioningSettingsImpl;
import com.azure.resourcemanager.security.implementation.AutomationsImpl;
import com.azure.resourcemanager.security.implementation.AzureDevOpsOrgsImpl;
import com.azure.resourcemanager.security.implementation.AzureDevOpsProjectsImpl;
import com.azure.resourcemanager.security.implementation.AzureDevOpsReposImpl;
import com.azure.resourcemanager.security.implementation.ComplianceResultsImpl;
import com.azure.resourcemanager.security.implementation.CompliancesImpl;
import com.azure.resourcemanager.security.implementation.ConnectorsImpl;
import com.azure.resourcemanager.security.implementation.CustomAssessmentAutomationsImpl;
import com.azure.resourcemanager.security.implementation.CustomEntityStoreAssignmentsImpl;
import com.azure.resourcemanager.security.implementation.DefenderForStoragesImpl;
import com.azure.resourcemanager.security.implementation.DevOpsConfigurationsImpl;
import com.azure.resourcemanager.security.implementation.DevOpsOperationResultsImpl;
import com.azure.resourcemanager.security.implementation.DeviceSecurityGroupsImpl;
import com.azure.resourcemanager.security.implementation.DiscoveredSecuritySolutionsImpl;
import com.azure.resourcemanager.security.implementation.ExternalSecuritySolutionsImpl;
import com.azure.resourcemanager.security.implementation.GitHubOwnersImpl;
import com.azure.resourcemanager.security.implementation.GitHubReposImpl;
import com.azure.resourcemanager.security.implementation.GitLabGroupsImpl;
import com.azure.resourcemanager.security.implementation.GitLabProjectsImpl;
import com.azure.resourcemanager.security.implementation.GitLabSubgroupsImpl;
import com.azure.resourcemanager.security.implementation.GovernanceAssignmentsImpl;
import com.azure.resourcemanager.security.implementation.GovernanceRulesImpl;
import com.azure.resourcemanager.security.implementation.HealthReportsImpl;
import com.azure.resourcemanager.security.implementation.InformationProtectionPoliciesImpl;
import com.azure.resourcemanager.security.implementation.IotSecuritySolutionAnalyticsImpl;
import com.azure.resourcemanager.security.implementation.IotSecuritySolutionsAnalyticsAggregatedAlertsImpl;
import com.azure.resourcemanager.security.implementation.IotSecuritySolutionsAnalyticsRecommendationsImpl;
import com.azure.resourcemanager.security.implementation.IotSecuritySolutionsImpl;
import com.azure.resourcemanager.security.implementation.JitNetworkAccessPoliciesImpl;
import com.azure.resourcemanager.security.implementation.LocationsImpl;
import com.azure.resourcemanager.security.implementation.MdeOnboardingsImpl;
import com.azure.resourcemanager.security.implementation.OperationsImpl;
import com.azure.resourcemanager.security.implementation.PricingsImpl;
import com.azure.resourcemanager.security.implementation.RegulatoryComplianceAssessmentsImpl;
import com.azure.resourcemanager.security.implementation.RegulatoryComplianceControlsImpl;
import com.azure.resourcemanager.security.implementation.RegulatoryComplianceStandardsImpl;
import com.azure.resourcemanager.security.implementation.ResourceProvidersImpl;
import com.azure.resourcemanager.security.implementation.SecureScoreControlDefinitionsImpl;
import com.azure.resourcemanager.security.implementation.SecureScoreControlsImpl;
import com.azure.resourcemanager.security.implementation.SecureScoresImpl;
import com.azure.resourcemanager.security.implementation.SecurityCenterBuilder;
import com.azure.resourcemanager.security.implementation.SecurityConnectorApplicationOperationsImpl;
import com.azure.resourcemanager.security.implementation.SecurityConnectorApplicationsImpl;
import com.azure.resourcemanager.security.implementation.SecurityConnectorsImpl;
import com.azure.resourcemanager.security.implementation.SecurityContactsImpl;
import com.azure.resourcemanager.security.implementation.SecurityOperatorsImpl;
import com.azure.resourcemanager.security.implementation.SecuritySolutionsImpl;
import com.azure.resourcemanager.security.implementation.SecuritySolutionsReferenceDatasImpl;
import com.azure.resourcemanager.security.implementation.SensitivitySettingsImpl;
import com.azure.resourcemanager.security.implementation.ServerVulnerabilityAssessmentsImpl;
import com.azure.resourcemanager.security.implementation.ServerVulnerabilityAssessmentsSettingsImpl;
import com.azure.resourcemanager.security.implementation.SettingsImpl;
import com.azure.resourcemanager.security.implementation.SoftwareInventoriesImpl;
import com.azure.resourcemanager.security.implementation.SqlVulnerabilityAssessmentBaselineRulesImpl;
import com.azure.resourcemanager.security.implementation.SqlVulnerabilityAssessmentScanResultsImpl;
import com.azure.resourcemanager.security.implementation.SqlVulnerabilityAssessmentScansImpl;
import com.azure.resourcemanager.security.implementation.SubAssessmentsImpl;
import com.azure.resourcemanager.security.implementation.TasksImpl;
import com.azure.resourcemanager.security.implementation.TopologiesImpl;
import com.azure.resourcemanager.security.implementation.WorkspaceSettingsImpl;
import com.azure.resourcemanager.security.models.AdaptiveApplicationControls;
import com.azure.resourcemanager.security.models.AdaptiveNetworkHardenings;
import com.azure.resourcemanager.security.models.AdvancedThreatProtections;
import com.azure.resourcemanager.security.models.Alerts;
import com.azure.resourcemanager.security.models.AlertsSuppressionRules;
import com.azure.resourcemanager.security.models.AllowedConnections;
import com.azure.resourcemanager.security.models.ApiCollections;
import com.azure.resourcemanager.security.models.ApplicationOperations;
import com.azure.resourcemanager.security.models.Applications;
import com.azure.resourcemanager.security.models.Assessments;
import com.azure.resourcemanager.security.models.AssessmentsMetadatas;
import com.azure.resourcemanager.security.models.AutoProvisioningSettings;
import com.azure.resourcemanager.security.models.Automations;
import com.azure.resourcemanager.security.models.AzureDevOpsOrgs;
import com.azure.resourcemanager.security.models.AzureDevOpsProjects;
import com.azure.resourcemanager.security.models.AzureDevOpsRepos;
import com.azure.resourcemanager.security.models.ComplianceResults;
import com.azure.resourcemanager.security.models.Compliances;
import com.azure.resourcemanager.security.models.Connectors;
import com.azure.resourcemanager.security.models.CustomAssessmentAutomations;
import com.azure.resourcemanager.security.models.CustomEntityStoreAssignments;
import com.azure.resourcemanager.security.models.DefenderForStorages;
import com.azure.resourcemanager.security.models.DevOpsConfigurations;
import com.azure.resourcemanager.security.models.DevOpsOperationResults;
import com.azure.resourcemanager.security.models.DeviceSecurityGroups;
import com.azure.resourcemanager.security.models.DiscoveredSecuritySolutions;
import com.azure.resourcemanager.security.models.ExternalSecuritySolutions;
import com.azure.resourcemanager.security.models.GitHubOwners;
import com.azure.resourcemanager.security.models.GitHubRepos;
import com.azure.resourcemanager.security.models.GitLabGroups;
import com.azure.resourcemanager.security.models.GitLabProjects;
import com.azure.resourcemanager.security.models.GitLabSubgroups;
import com.azure.resourcemanager.security.models.GovernanceAssignments;
import com.azure.resourcemanager.security.models.GovernanceRules;
import com.azure.resourcemanager.security.models.HealthReports;
import com.azure.resourcemanager.security.models.InformationProtectionPolicies;
import com.azure.resourcemanager.security.models.IotSecuritySolutionAnalytics;
import com.azure.resourcemanager.security.models.IotSecuritySolutions;
import com.azure.resourcemanager.security.models.IotSecuritySolutionsAnalyticsAggregatedAlerts;
import com.azure.resourcemanager.security.models.IotSecuritySolutionsAnalyticsRecommendations;
import com.azure.resourcemanager.security.models.JitNetworkAccessPolicies;
import com.azure.resourcemanager.security.models.Locations;
import com.azure.resourcemanager.security.models.MdeOnboardings;
import com.azure.resourcemanager.security.models.Operations;
import com.azure.resourcemanager.security.models.Pricings;
import com.azure.resourcemanager.security.models.RegulatoryComplianceAssessments;
import com.azure.resourcemanager.security.models.RegulatoryComplianceControls;
import com.azure.resourcemanager.security.models.RegulatoryComplianceStandards;
import com.azure.resourcemanager.security.models.ResourceProviders;
import com.azure.resourcemanager.security.models.SecureScoreControlDefinitions;
import com.azure.resourcemanager.security.models.SecureScoreControls;
import com.azure.resourcemanager.security.models.SecureScores;
import com.azure.resourcemanager.security.models.SecurityConnectorApplicationOperations;
import com.azure.resourcemanager.security.models.SecurityConnectorApplications;
import com.azure.resourcemanager.security.models.SecurityConnectors;
import com.azure.resourcemanager.security.models.SecurityContacts;
import com.azure.resourcemanager.security.models.SecurityOperators;
import com.azure.resourcemanager.security.models.SecuritySolutions;
import com.azure.resourcemanager.security.models.SecuritySolutionsReferenceDatas;
import com.azure.resourcemanager.security.models.SensitivitySettings;
import com.azure.resourcemanager.security.models.ServerVulnerabilityAssessments;
import com.azure.resourcemanager.security.models.ServerVulnerabilityAssessmentsSettings;
import com.azure.resourcemanager.security.models.Settings;
import com.azure.resourcemanager.security.models.SoftwareInventories;
import com.azure.resourcemanager.security.models.SqlVulnerabilityAssessmentBaselineRules;
import com.azure.resourcemanager.security.models.SqlVulnerabilityAssessmentScanResults;
import com.azure.resourcemanager.security.models.SqlVulnerabilityAssessmentScans;
import com.azure.resourcemanager.security.models.SubAssessments;
import com.azure.resourcemanager.security.models.Tasks;
import com.azure.resourcemanager.security.models.Topologies;
import com.azure.resourcemanager.security.models.WorkspaceSettings;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SecurityManager {
    private Locations locations;
    private Operations operations;
    private Tasks tasks;
    private AutoProvisioningSettings autoProvisioningSettings;
    private Compliances compliances;
    private InformationProtectionPolicies informationProtectionPolicies;
    private WorkspaceSettings workspaceSettings;
    private AlertsSuppressionRules alertsSuppressionRules;
    private Automations automations;
    private RegulatoryComplianceStandards regulatoryComplianceStandards;
    private RegulatoryComplianceControls regulatoryComplianceControls;
    private RegulatoryComplianceAssessments regulatoryComplianceAssessments;
    private SubAssessments subAssessments;
    private Connectors connectors;
    private SecurityContacts securityContacts;
    private SoftwareInventories softwareInventories;
    private CustomAssessmentAutomations customAssessmentAutomations;
    private CustomEntityStoreAssignments customEntityStoreAssignments;
    private MdeOnboardings mdeOnboardings;
    private GovernanceAssignments governanceAssignments;
    private GovernanceRules governanceRules;
    private Applications applications;
    private ApplicationOperations applicationOperations;
    private SecurityConnectorApplications securityConnectorApplications;
    private SecurityConnectorApplicationOperations securityConnectorApplicationOperations;
    private DefenderForStorages defenderForStorages;
    private SecurityOperators securityOperators;
    private SqlVulnerabilityAssessmentBaselineRules sqlVulnerabilityAssessmentBaselineRules;
    private SqlVulnerabilityAssessmentScans sqlVulnerabilityAssessmentScans;
    private SqlVulnerabilityAssessmentScanResults sqlVulnerabilityAssessmentScanResults;
    private ResourceProviders resourceProviders;
    private SensitivitySettings sensitivitySettings;
    private HealthReports healthReports;
    private AzureDevOpsOrgs azureDevOpsOrgs;
    private AzureDevOpsProjects azureDevOpsProjects;
    private AzureDevOpsRepos azureDevOpsRepos;
    private DevOpsConfigurations devOpsConfigurations;
    private GitHubOwners gitHubOwners;
    private GitHubRepos gitHubRepos;
    private GitLabGroups gitLabGroups;
    private GitLabSubgroups gitLabSubgroups;
    private GitLabProjects gitLabProjects;
    private DevOpsOperationResults devOpsOperationResults;
    private SecurityConnectors securityConnectors;
    private ComplianceResults complianceResults;
    private AdvancedThreatProtections advancedThreatProtections;
    private DeviceSecurityGroups deviceSecurityGroups;
    private IotSecuritySolutionAnalytics iotSecuritySolutionAnalytics;
    private IotSecuritySolutionsAnalyticsAggregatedAlerts iotSecuritySolutionsAnalyticsAggregatedAlerts;
    private IotSecuritySolutionsAnalyticsRecommendations iotSecuritySolutionsAnalyticsRecommendations;
    private IotSecuritySolutions iotSecuritySolutions;
    private AdaptiveNetworkHardenings adaptiveNetworkHardenings;
    private AllowedConnections allowedConnections;
    private AdaptiveApplicationControls adaptiveApplicationControls;
    private DiscoveredSecuritySolutions discoveredSecuritySolutions;
    private ExternalSecuritySolutions externalSecuritySolutions;
    private JitNetworkAccessPolicies jitNetworkAccessPolicies;
    private SecureScores secureScores;
    private SecureScoreControls secureScoreControls;
    private SecureScoreControlDefinitions secureScoreControlDefinitions;
    private SecuritySolutions securitySolutions;
    private SecuritySolutionsReferenceDatas securitySolutionsReferenceDatas;
    private ServerVulnerabilityAssessments serverVulnerabilityAssessments;
    private Topologies topologies;
    private AssessmentsMetadatas assessmentsMetadatas;
    private Assessments assessments;
    private Alerts alerts;
    private Settings settings;
    private ServerVulnerabilityAssessmentsSettings serverVulnerabilityAssessmentsSettings;
    private ApiCollections apiCollections;
    private Pricings pricings;
    private final SecurityCenter clientObject;

    private SecurityManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new SecurityCenterBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static SecurityManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return SecurityManager.configure().authenticate(credential, profile);
    }

    public static SecurityManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new SecurityManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Locations locations() {
        if (this.locations == null) {
            this.locations = new LocationsImpl(this.clientObject.getLocations(), this);
        }
        return this.locations;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public Tasks tasks() {
        if (this.tasks == null) {
            this.tasks = new TasksImpl(this.clientObject.getTasks(), this);
        }
        return this.tasks;
    }

    public AutoProvisioningSettings autoProvisioningSettings() {
        if (this.autoProvisioningSettings == null) {
            this.autoProvisioningSettings = new AutoProvisioningSettingsImpl(this.clientObject.getAutoProvisioningSettings(), this);
        }
        return this.autoProvisioningSettings;
    }

    public Compliances compliances() {
        if (this.compliances == null) {
            this.compliances = new CompliancesImpl(this.clientObject.getCompliances(), this);
        }
        return this.compliances;
    }

    public InformationProtectionPolicies informationProtectionPolicies() {
        if (this.informationProtectionPolicies == null) {
            this.informationProtectionPolicies = new InformationProtectionPoliciesImpl(this.clientObject.getInformationProtectionPolicies(), this);
        }
        return this.informationProtectionPolicies;
    }

    public WorkspaceSettings workspaceSettings() {
        if (this.workspaceSettings == null) {
            this.workspaceSettings = new WorkspaceSettingsImpl(this.clientObject.getWorkspaceSettings(), this);
        }
        return this.workspaceSettings;
    }

    public AlertsSuppressionRules alertsSuppressionRules() {
        if (this.alertsSuppressionRules == null) {
            this.alertsSuppressionRules = new AlertsSuppressionRulesImpl(this.clientObject.getAlertsSuppressionRules(), this);
        }
        return this.alertsSuppressionRules;
    }

    public Automations automations() {
        if (this.automations == null) {
            this.automations = new AutomationsImpl(this.clientObject.getAutomations(), this);
        }
        return this.automations;
    }

    public RegulatoryComplianceStandards regulatoryComplianceStandards() {
        if (this.regulatoryComplianceStandards == null) {
            this.regulatoryComplianceStandards = new RegulatoryComplianceStandardsImpl(this.clientObject.getRegulatoryComplianceStandards(), this);
        }
        return this.regulatoryComplianceStandards;
    }

    public RegulatoryComplianceControls regulatoryComplianceControls() {
        if (this.regulatoryComplianceControls == null) {
            this.regulatoryComplianceControls = new RegulatoryComplianceControlsImpl(this.clientObject.getRegulatoryComplianceControls(), this);
        }
        return this.regulatoryComplianceControls;
    }

    public RegulatoryComplianceAssessments regulatoryComplianceAssessments() {
        if (this.regulatoryComplianceAssessments == null) {
            this.regulatoryComplianceAssessments = new RegulatoryComplianceAssessmentsImpl(this.clientObject.getRegulatoryComplianceAssessments(), this);
        }
        return this.regulatoryComplianceAssessments;
    }

    public SubAssessments subAssessments() {
        if (this.subAssessments == null) {
            this.subAssessments = new SubAssessmentsImpl(this.clientObject.getSubAssessments(), this);
        }
        return this.subAssessments;
    }

    public Connectors connectors() {
        if (this.connectors == null) {
            this.connectors = new ConnectorsImpl(this.clientObject.getConnectors(), this);
        }
        return this.connectors;
    }

    public SecurityContacts securityContacts() {
        if (this.securityContacts == null) {
            this.securityContacts = new SecurityContactsImpl(this.clientObject.getSecurityContacts(), this);
        }
        return this.securityContacts;
    }

    public SoftwareInventories softwareInventories() {
        if (this.softwareInventories == null) {
            this.softwareInventories = new SoftwareInventoriesImpl(this.clientObject.getSoftwareInventories(), this);
        }
        return this.softwareInventories;
    }

    public CustomAssessmentAutomations customAssessmentAutomations() {
        if (this.customAssessmentAutomations == null) {
            this.customAssessmentAutomations = new CustomAssessmentAutomationsImpl(this.clientObject.getCustomAssessmentAutomations(), this);
        }
        return this.customAssessmentAutomations;
    }

    public CustomEntityStoreAssignments customEntityStoreAssignments() {
        if (this.customEntityStoreAssignments == null) {
            this.customEntityStoreAssignments = new CustomEntityStoreAssignmentsImpl(this.clientObject.getCustomEntityStoreAssignments(), this);
        }
        return this.customEntityStoreAssignments;
    }

    public MdeOnboardings mdeOnboardings() {
        if (this.mdeOnboardings == null) {
            this.mdeOnboardings = new MdeOnboardingsImpl(this.clientObject.getMdeOnboardings(), this);
        }
        return this.mdeOnboardings;
    }

    public GovernanceAssignments governanceAssignments() {
        if (this.governanceAssignments == null) {
            this.governanceAssignments = new GovernanceAssignmentsImpl(this.clientObject.getGovernanceAssignments(), this);
        }
        return this.governanceAssignments;
    }

    public GovernanceRules governanceRules() {
        if (this.governanceRules == null) {
            this.governanceRules = new GovernanceRulesImpl(this.clientObject.getGovernanceRules(), this);
        }
        return this.governanceRules;
    }

    public Applications applications() {
        if (this.applications == null) {
            this.applications = new ApplicationsImpl(this.clientObject.getApplications(), this);
        }
        return this.applications;
    }

    public ApplicationOperations applicationOperations() {
        if (this.applicationOperations == null) {
            this.applicationOperations = new ApplicationOperationsImpl(this.clientObject.getApplicationOperations(), this);
        }
        return this.applicationOperations;
    }

    public SecurityConnectorApplications securityConnectorApplications() {
        if (this.securityConnectorApplications == null) {
            this.securityConnectorApplications = new SecurityConnectorApplicationsImpl(this.clientObject.getSecurityConnectorApplications(), this);
        }
        return this.securityConnectorApplications;
    }

    public SecurityConnectorApplicationOperations securityConnectorApplicationOperations() {
        if (this.securityConnectorApplicationOperations == null) {
            this.securityConnectorApplicationOperations = new SecurityConnectorApplicationOperationsImpl(this.clientObject.getSecurityConnectorApplicationOperations(), this);
        }
        return this.securityConnectorApplicationOperations;
    }

    public DefenderForStorages defenderForStorages() {
        if (this.defenderForStorages == null) {
            this.defenderForStorages = new DefenderForStoragesImpl(this.clientObject.getDefenderForStorages(), this);
        }
        return this.defenderForStorages;
    }

    public SecurityOperators securityOperators() {
        if (this.securityOperators == null) {
            this.securityOperators = new SecurityOperatorsImpl(this.clientObject.getSecurityOperators(), this);
        }
        return this.securityOperators;
    }

    public SqlVulnerabilityAssessmentBaselineRules sqlVulnerabilityAssessmentBaselineRules() {
        if (this.sqlVulnerabilityAssessmentBaselineRules == null) {
            this.sqlVulnerabilityAssessmentBaselineRules = new SqlVulnerabilityAssessmentBaselineRulesImpl(this.clientObject.getSqlVulnerabilityAssessmentBaselineRules(), this);
        }
        return this.sqlVulnerabilityAssessmentBaselineRules;
    }

    public SqlVulnerabilityAssessmentScans sqlVulnerabilityAssessmentScans() {
        if (this.sqlVulnerabilityAssessmentScans == null) {
            this.sqlVulnerabilityAssessmentScans = new SqlVulnerabilityAssessmentScansImpl(this.clientObject.getSqlVulnerabilityAssessmentScans(), this);
        }
        return this.sqlVulnerabilityAssessmentScans;
    }

    public SqlVulnerabilityAssessmentScanResults sqlVulnerabilityAssessmentScanResults() {
        if (this.sqlVulnerabilityAssessmentScanResults == null) {
            this.sqlVulnerabilityAssessmentScanResults = new SqlVulnerabilityAssessmentScanResultsImpl(this.clientObject.getSqlVulnerabilityAssessmentScanResults(), this);
        }
        return this.sqlVulnerabilityAssessmentScanResults;
    }

    public ResourceProviders resourceProviders() {
        if (this.resourceProviders == null) {
            this.resourceProviders = new ResourceProvidersImpl(this.clientObject.getResourceProviders(), this);
        }
        return this.resourceProviders;
    }

    public SensitivitySettings sensitivitySettings() {
        if (this.sensitivitySettings == null) {
            this.sensitivitySettings = new SensitivitySettingsImpl(this.clientObject.getSensitivitySettings(), this);
        }
        return this.sensitivitySettings;
    }

    public HealthReports healthReports() {
        if (this.healthReports == null) {
            this.healthReports = new HealthReportsImpl(this.clientObject.getHealthReports(), this);
        }
        return this.healthReports;
    }

    public AzureDevOpsOrgs azureDevOpsOrgs() {
        if (this.azureDevOpsOrgs == null) {
            this.azureDevOpsOrgs = new AzureDevOpsOrgsImpl(this.clientObject.getAzureDevOpsOrgs(), this);
        }
        return this.azureDevOpsOrgs;
    }

    public AzureDevOpsProjects azureDevOpsProjects() {
        if (this.azureDevOpsProjects == null) {
            this.azureDevOpsProjects = new AzureDevOpsProjectsImpl(this.clientObject.getAzureDevOpsProjects(), this);
        }
        return this.azureDevOpsProjects;
    }

    public AzureDevOpsRepos azureDevOpsRepos() {
        if (this.azureDevOpsRepos == null) {
            this.azureDevOpsRepos = new AzureDevOpsReposImpl(this.clientObject.getAzureDevOpsRepos(), this);
        }
        return this.azureDevOpsRepos;
    }

    public DevOpsConfigurations devOpsConfigurations() {
        if (this.devOpsConfigurations == null) {
            this.devOpsConfigurations = new DevOpsConfigurationsImpl(this.clientObject.getDevOpsConfigurations(), this);
        }
        return this.devOpsConfigurations;
    }

    public GitHubOwners gitHubOwners() {
        if (this.gitHubOwners == null) {
            this.gitHubOwners = new GitHubOwnersImpl(this.clientObject.getGitHubOwners(), this);
        }
        return this.gitHubOwners;
    }

    public GitHubRepos gitHubRepos() {
        if (this.gitHubRepos == null) {
            this.gitHubRepos = new GitHubReposImpl(this.clientObject.getGitHubRepos(), this);
        }
        return this.gitHubRepos;
    }

    public GitLabGroups gitLabGroups() {
        if (this.gitLabGroups == null) {
            this.gitLabGroups = new GitLabGroupsImpl(this.clientObject.getGitLabGroups(), this);
        }
        return this.gitLabGroups;
    }

    public GitLabSubgroups gitLabSubgroups() {
        if (this.gitLabSubgroups == null) {
            this.gitLabSubgroups = new GitLabSubgroupsImpl(this.clientObject.getGitLabSubgroups(), this);
        }
        return this.gitLabSubgroups;
    }

    public GitLabProjects gitLabProjects() {
        if (this.gitLabProjects == null) {
            this.gitLabProjects = new GitLabProjectsImpl(this.clientObject.getGitLabProjects(), this);
        }
        return this.gitLabProjects;
    }

    public DevOpsOperationResults devOpsOperationResults() {
        if (this.devOpsOperationResults == null) {
            this.devOpsOperationResults = new DevOpsOperationResultsImpl(this.clientObject.getDevOpsOperationResults(), this);
        }
        return this.devOpsOperationResults;
    }

    public SecurityConnectors securityConnectors() {
        if (this.securityConnectors == null) {
            this.securityConnectors = new SecurityConnectorsImpl(this.clientObject.getSecurityConnectors(), this);
        }
        return this.securityConnectors;
    }

    public ComplianceResults complianceResults() {
        if (this.complianceResults == null) {
            this.complianceResults = new ComplianceResultsImpl(this.clientObject.getComplianceResults(), this);
        }
        return this.complianceResults;
    }

    public AdvancedThreatProtections advancedThreatProtections() {
        if (this.advancedThreatProtections == null) {
            this.advancedThreatProtections = new AdvancedThreatProtectionsImpl(this.clientObject.getAdvancedThreatProtections(), this);
        }
        return this.advancedThreatProtections;
    }

    public DeviceSecurityGroups deviceSecurityGroups() {
        if (this.deviceSecurityGroups == null) {
            this.deviceSecurityGroups = new DeviceSecurityGroupsImpl(this.clientObject.getDeviceSecurityGroups(), this);
        }
        return this.deviceSecurityGroups;
    }

    public IotSecuritySolutionAnalytics iotSecuritySolutionAnalytics() {
        if (this.iotSecuritySolutionAnalytics == null) {
            this.iotSecuritySolutionAnalytics = new IotSecuritySolutionAnalyticsImpl(this.clientObject.getIotSecuritySolutionAnalytics(), this);
        }
        return this.iotSecuritySolutionAnalytics;
    }

    public IotSecuritySolutionsAnalyticsAggregatedAlerts iotSecuritySolutionsAnalyticsAggregatedAlerts() {
        if (this.iotSecuritySolutionsAnalyticsAggregatedAlerts == null) {
            this.iotSecuritySolutionsAnalyticsAggregatedAlerts = new IotSecuritySolutionsAnalyticsAggregatedAlertsImpl(this.clientObject.getIotSecuritySolutionsAnalyticsAggregatedAlerts(), this);
        }
        return this.iotSecuritySolutionsAnalyticsAggregatedAlerts;
    }

    public IotSecuritySolutionsAnalyticsRecommendations iotSecuritySolutionsAnalyticsRecommendations() {
        if (this.iotSecuritySolutionsAnalyticsRecommendations == null) {
            this.iotSecuritySolutionsAnalyticsRecommendations = new IotSecuritySolutionsAnalyticsRecommendationsImpl(this.clientObject.getIotSecuritySolutionsAnalyticsRecommendations(), this);
        }
        return this.iotSecuritySolutionsAnalyticsRecommendations;
    }

    public IotSecuritySolutions iotSecuritySolutions() {
        if (this.iotSecuritySolutions == null) {
            this.iotSecuritySolutions = new IotSecuritySolutionsImpl(this.clientObject.getIotSecuritySolutions(), this);
        }
        return this.iotSecuritySolutions;
    }

    public AdaptiveNetworkHardenings adaptiveNetworkHardenings() {
        if (this.adaptiveNetworkHardenings == null) {
            this.adaptiveNetworkHardenings = new AdaptiveNetworkHardeningsImpl(this.clientObject.getAdaptiveNetworkHardenings(), this);
        }
        return this.adaptiveNetworkHardenings;
    }

    public AllowedConnections allowedConnections() {
        if (this.allowedConnections == null) {
            this.allowedConnections = new AllowedConnectionsImpl(this.clientObject.getAllowedConnections(), this);
        }
        return this.allowedConnections;
    }

    public AdaptiveApplicationControls adaptiveApplicationControls() {
        if (this.adaptiveApplicationControls == null) {
            this.adaptiveApplicationControls = new AdaptiveApplicationControlsImpl(this.clientObject.getAdaptiveApplicationControls(), this);
        }
        return this.adaptiveApplicationControls;
    }

    public DiscoveredSecuritySolutions discoveredSecuritySolutions() {
        if (this.discoveredSecuritySolutions == null) {
            this.discoveredSecuritySolutions = new DiscoveredSecuritySolutionsImpl(this.clientObject.getDiscoveredSecuritySolutions(), this);
        }
        return this.discoveredSecuritySolutions;
    }

    public ExternalSecuritySolutions externalSecuritySolutions() {
        if (this.externalSecuritySolutions == null) {
            this.externalSecuritySolutions = new ExternalSecuritySolutionsImpl(this.clientObject.getExternalSecuritySolutions(), this);
        }
        return this.externalSecuritySolutions;
    }

    public JitNetworkAccessPolicies jitNetworkAccessPolicies() {
        if (this.jitNetworkAccessPolicies == null) {
            this.jitNetworkAccessPolicies = new JitNetworkAccessPoliciesImpl(this.clientObject.getJitNetworkAccessPolicies(), this);
        }
        return this.jitNetworkAccessPolicies;
    }

    public SecureScores secureScores() {
        if (this.secureScores == null) {
            this.secureScores = new SecureScoresImpl(this.clientObject.getSecureScores(), this);
        }
        return this.secureScores;
    }

    public SecureScoreControls secureScoreControls() {
        if (this.secureScoreControls == null) {
            this.secureScoreControls = new SecureScoreControlsImpl(this.clientObject.getSecureScoreControls(), this);
        }
        return this.secureScoreControls;
    }

    public SecureScoreControlDefinitions secureScoreControlDefinitions() {
        if (this.secureScoreControlDefinitions == null) {
            this.secureScoreControlDefinitions = new SecureScoreControlDefinitionsImpl(this.clientObject.getSecureScoreControlDefinitions(), this);
        }
        return this.secureScoreControlDefinitions;
    }

    public SecuritySolutions securitySolutions() {
        if (this.securitySolutions == null) {
            this.securitySolutions = new SecuritySolutionsImpl(this.clientObject.getSecuritySolutions(), this);
        }
        return this.securitySolutions;
    }

    public SecuritySolutionsReferenceDatas securitySolutionsReferenceDatas() {
        if (this.securitySolutionsReferenceDatas == null) {
            this.securitySolutionsReferenceDatas = new SecuritySolutionsReferenceDatasImpl(this.clientObject.getSecuritySolutionsReferenceDatas(), this);
        }
        return this.securitySolutionsReferenceDatas;
    }

    public ServerVulnerabilityAssessments serverVulnerabilityAssessments() {
        if (this.serverVulnerabilityAssessments == null) {
            this.serverVulnerabilityAssessments = new ServerVulnerabilityAssessmentsImpl(this.clientObject.getServerVulnerabilityAssessments(), this);
        }
        return this.serverVulnerabilityAssessments;
    }

    public Topologies topologies() {
        if (this.topologies == null) {
            this.topologies = new TopologiesImpl(this.clientObject.getTopologies(), this);
        }
        return this.topologies;
    }

    public AssessmentsMetadatas assessmentsMetadatas() {
        if (this.assessmentsMetadatas == null) {
            this.assessmentsMetadatas = new AssessmentsMetadatasImpl(this.clientObject.getAssessmentsMetadatas(), this);
        }
        return this.assessmentsMetadatas;
    }

    public Assessments assessments() {
        if (this.assessments == null) {
            this.assessments = new AssessmentsImpl(this.clientObject.getAssessments(), this);
        }
        return this.assessments;
    }

    public Alerts alerts() {
        if (this.alerts == null) {
            this.alerts = new AlertsImpl(this.clientObject.getAlerts(), this);
        }
        return this.alerts;
    }

    public Settings settings() {
        if (this.settings == null) {
            this.settings = new SettingsImpl(this.clientObject.getSettings(), this);
        }
        return this.settings;
    }

    public ServerVulnerabilityAssessmentsSettings serverVulnerabilityAssessmentsSettings() {
        if (this.serverVulnerabilityAssessmentsSettings == null) {
            this.serverVulnerabilityAssessmentsSettings = new ServerVulnerabilityAssessmentsSettingsImpl(this.clientObject.getServerVulnerabilityAssessmentsSettings(), this);
        }
        return this.serverVulnerabilityAssessmentsSettings;
    }

    public ApiCollections apiCollections() {
        if (this.apiCollections == null) {
            this.apiCollections = new ApiCollectionsImpl(this.clientObject.getApiCollections(), this);
        }
        return this.apiCollections;
    }

    public Pricings pricings() {
        if (this.pricings == null) {
            this.pricings = new PricingsImpl(this.clientObject.getPricings(), this);
        }
        return this.pricings;
    }

    public SecurityCenter serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public SecurityManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.security").append("/").append("1.0.0-beta.6");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new SecurityManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

