/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.resourcemanager.security.models.AdaptiveApplicationControlIssueSummary;
import com.azure.resourcemanager.security.models.ConfigurationStatus;
import com.azure.resourcemanager.security.models.EnforcementMode;
import com.azure.resourcemanager.security.models.PathRecommendation;
import com.azure.resourcemanager.security.models.ProtectionMode;
import com.azure.resourcemanager.security.models.RecommendationStatus;
import com.azure.resourcemanager.security.models.SourceSystem;
import com.azure.resourcemanager.security.models.VmRecommendation;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AdaptiveApplicationControlGroupData {
    @JsonProperty(value="enforcementMode")
    private EnforcementMode enforcementMode;
    @JsonProperty(value="protectionMode")
    private ProtectionMode protectionMode;
    @JsonProperty(value="configurationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private ConfigurationStatus configurationStatus;
    @JsonProperty(value="recommendationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private RecommendationStatus recommendationStatus;
    @JsonProperty(value="issues", access=JsonProperty.Access.WRITE_ONLY)
    private List<AdaptiveApplicationControlIssueSummary> issues;
    @JsonProperty(value="sourceSystem", access=JsonProperty.Access.WRITE_ONLY)
    private SourceSystem sourceSystem;
    @JsonProperty(value="vmRecommendations")
    private List<VmRecommendation> vmRecommendations;
    @JsonProperty(value="pathRecommendations")
    private List<PathRecommendation> pathRecommendations;

    public EnforcementMode enforcementMode() {
        return this.enforcementMode;
    }

    public AdaptiveApplicationControlGroupData withEnforcementMode(EnforcementMode enforcementMode) {
        this.enforcementMode = enforcementMode;
        return this;
    }

    public ProtectionMode protectionMode() {
        return this.protectionMode;
    }

    public AdaptiveApplicationControlGroupData withProtectionMode(ProtectionMode protectionMode) {
        this.protectionMode = protectionMode;
        return this;
    }

    public ConfigurationStatus configurationStatus() {
        return this.configurationStatus;
    }

    public RecommendationStatus recommendationStatus() {
        return this.recommendationStatus;
    }

    public List<AdaptiveApplicationControlIssueSummary> issues() {
        return this.issues;
    }

    public SourceSystem sourceSystem() {
        return this.sourceSystem;
    }

    public List<VmRecommendation> vmRecommendations() {
        return this.vmRecommendations;
    }

    public AdaptiveApplicationControlGroupData withVmRecommendations(List<VmRecommendation> vmRecommendations) {
        this.vmRecommendations = vmRecommendations;
        return this;
    }

    public List<PathRecommendation> pathRecommendations() {
        return this.pathRecommendations;
    }

    public AdaptiveApplicationControlGroupData withPathRecommendations(List<PathRecommendation> pathRecommendations) {
        this.pathRecommendations = pathRecommendations;
        return this;
    }

    public void validate() {
        if (this.protectionMode() != null) {
            this.protectionMode().validate();
        }
        if (this.issues() != null) {
            this.issues().forEach(e -> e.validate());
        }
        if (this.vmRecommendations() != null) {
            this.vmRecommendations().forEach(e -> e.validate());
        }
        if (this.pathRecommendations() != null) {
            this.pathRecommendations().forEach(e -> e.validate());
        }
    }
}

