/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.fluent.models.AdaptiveApplicationControlGroupData;
import com.azure.resourcemanager.security.models.AdaptiveApplicationControlIssueSummary;
import com.azure.resourcemanager.security.models.ConfigurationStatus;
import com.azure.resourcemanager.security.models.EnforcementMode;
import com.azure.resourcemanager.security.models.PathRecommendation;
import com.azure.resourcemanager.security.models.ProtectionMode;
import com.azure.resourcemanager.security.models.RecommendationStatus;
import com.azure.resourcemanager.security.models.SourceSystem;
import com.azure.resourcemanager.security.models.VmRecommendation;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AdaptiveApplicationControlGroupInner
extends ProxyResource {
    @JsonProperty(value="properties", required=true)
    private AdaptiveApplicationControlGroupData innerProperties = new AdaptiveApplicationControlGroupData();
    @JsonProperty(value="location", access=JsonProperty.Access.WRITE_ONLY)
    private String location;
    private static final ClientLogger LOGGER = new ClientLogger(AdaptiveApplicationControlGroupInner.class);

    private AdaptiveApplicationControlGroupData innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public EnforcementMode enforcementMode() {
        return this.innerProperties() == null ? null : this.innerProperties().enforcementMode();
    }

    public AdaptiveApplicationControlGroupInner withEnforcementMode(EnforcementMode enforcementMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdaptiveApplicationControlGroupData();
        }
        this.innerProperties().withEnforcementMode(enforcementMode);
        return this;
    }

    public ProtectionMode protectionMode() {
        return this.innerProperties() == null ? null : this.innerProperties().protectionMode();
    }

    public AdaptiveApplicationControlGroupInner withProtectionMode(ProtectionMode protectionMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdaptiveApplicationControlGroupData();
        }
        this.innerProperties().withProtectionMode(protectionMode);
        return this;
    }

    public ConfigurationStatus configurationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationStatus();
    }

    public RecommendationStatus recommendationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendationStatus();
    }

    public List<AdaptiveApplicationControlIssueSummary> issues() {
        return this.innerProperties() == null ? null : this.innerProperties().issues();
    }

    public SourceSystem sourceSystem() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceSystem();
    }

    public List<VmRecommendation> vmRecommendations() {
        return this.innerProperties() == null ? null : this.innerProperties().vmRecommendations();
    }

    public AdaptiveApplicationControlGroupInner withVmRecommendations(List<VmRecommendation> vmRecommendations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdaptiveApplicationControlGroupData();
        }
        this.innerProperties().withVmRecommendations(vmRecommendations);
        return this;
    }

    public List<PathRecommendation> pathRecommendations() {
        return this.innerProperties() == null ? null : this.innerProperties().pathRecommendations();
    }

    public AdaptiveApplicationControlGroupInner withPathRecommendations(List<PathRecommendation> pathRecommendations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdaptiveApplicationControlGroupData();
        }
        this.innerProperties().withPathRecommendations(pathRecommendations);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model AdaptiveApplicationControlGroupInner"));
        }
        this.innerProperties().validate();
    }
}

