/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.RuleState;
import com.azure.resourcemanager.security.models.SuppressionAlertsScope;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class AlertsSuppressionRuleProperties {
    @JsonProperty(value="alertType", required=true)
    private String alertType;
    @JsonProperty(value="lastModifiedUtc", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedUtc;
    @JsonProperty(value="expirationDateUtc")
    private OffsetDateTime expirationDateUtc;
    @JsonProperty(value="reason", required=true)
    private String reason;
    @JsonProperty(value="state", required=true)
    private RuleState state;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="suppressionAlertsScope")
    private SuppressionAlertsScope suppressionAlertsScope;
    private static final ClientLogger LOGGER = new ClientLogger(AlertsSuppressionRuleProperties.class);

    public String alertType() {
        return this.alertType;
    }

    public AlertsSuppressionRuleProperties withAlertType(String alertType) {
        this.alertType = alertType;
        return this;
    }

    public OffsetDateTime lastModifiedUtc() {
        return this.lastModifiedUtc;
    }

    public OffsetDateTime expirationDateUtc() {
        return this.expirationDateUtc;
    }

    public AlertsSuppressionRuleProperties withExpirationDateUtc(OffsetDateTime expirationDateUtc) {
        this.expirationDateUtc = expirationDateUtc;
        return this;
    }

    public String reason() {
        return this.reason;
    }

    public AlertsSuppressionRuleProperties withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public RuleState state() {
        return this.state;
    }

    public AlertsSuppressionRuleProperties withState(RuleState state) {
        this.state = state;
        return this;
    }

    public String comment() {
        return this.comment;
    }

    public AlertsSuppressionRuleProperties withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public SuppressionAlertsScope suppressionAlertsScope() {
        return this.suppressionAlertsScope;
    }

    public AlertsSuppressionRuleProperties withSuppressionAlertsScope(SuppressionAlertsScope suppressionAlertsScope) {
        this.suppressionAlertsScope = suppressionAlertsScope;
        return this;
    }

    public void validate() {
        if (this.alertType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property alertType in model AlertsSuppressionRuleProperties"));
        }
        if (this.reason() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property reason in model AlertsSuppressionRuleProperties"));
        }
        if (this.state() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property state in model AlertsSuppressionRuleProperties"));
        }
        if (this.suppressionAlertsScope() != null) {
            this.suppressionAlertsScope().validate();
        }
    }
}

