/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.ApplicationSourceResourceType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ApplicationProperties {
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="sourceResourceType", required=true)
    private ApplicationSourceResourceType sourceResourceType;
    @JsonProperty(value="conditionSets", required=true)
    private List<Object> conditionSets;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public ApplicationProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ApplicationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public ApplicationSourceResourceType sourceResourceType() {
        return this.sourceResourceType;
    }

    public ApplicationProperties withSourceResourceType(ApplicationSourceResourceType sourceResourceType) {
        this.sourceResourceType = sourceResourceType;
        return this;
    }

    public List<Object> conditionSets() {
        return this.conditionSets;
    }

    public ApplicationProperties withConditionSets(List<Object> conditionSets) {
        this.conditionSets = conditionSets;
        return this;
    }

    public void validate() {
        if (this.sourceResourceType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceResourceType in model ApplicationProperties"));
        }
        if (this.conditionSets() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property conditionSets in model ApplicationProperties"));
        }
    }
}

