/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.GovernanceAssignmentAdditionalData;
import com.azure.resourcemanager.security.models.GovernanceEmailNotification;
import com.azure.resourcemanager.security.models.RemediationEta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class GovernanceAssignmentProperties {
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="remediationDueDate", required=true)
    private OffsetDateTime remediationDueDate;
    @JsonProperty(value="remediationEta")
    private RemediationEta remediationEta;
    @JsonProperty(value="isGracePeriod")
    private Boolean isGracePeriod;
    @JsonProperty(value="governanceEmailNotification")
    private GovernanceEmailNotification governanceEmailNotification;
    @JsonProperty(value="additionalData")
    private GovernanceAssignmentAdditionalData additionalData;
    private static final ClientLogger LOGGER = new ClientLogger(GovernanceAssignmentProperties.class);

    public String owner() {
        return this.owner;
    }

    public GovernanceAssignmentProperties withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public OffsetDateTime remediationDueDate() {
        return this.remediationDueDate;
    }

    public GovernanceAssignmentProperties withRemediationDueDate(OffsetDateTime remediationDueDate) {
        this.remediationDueDate = remediationDueDate;
        return this;
    }

    public RemediationEta remediationEta() {
        return this.remediationEta;
    }

    public GovernanceAssignmentProperties withRemediationEta(RemediationEta remediationEta) {
        this.remediationEta = remediationEta;
        return this;
    }

    public Boolean isGracePeriod() {
        return this.isGracePeriod;
    }

    public GovernanceAssignmentProperties withIsGracePeriod(Boolean isGracePeriod) {
        this.isGracePeriod = isGracePeriod;
        return this;
    }

    public GovernanceEmailNotification governanceEmailNotification() {
        return this.governanceEmailNotification;
    }

    public GovernanceAssignmentProperties withGovernanceEmailNotification(GovernanceEmailNotification governanceEmailNotification) {
        this.governanceEmailNotification = governanceEmailNotification;
        return this;
    }

    public GovernanceAssignmentAdditionalData additionalData() {
        return this.additionalData;
    }

    public GovernanceAssignmentProperties withAdditionalData(GovernanceAssignmentAdditionalData additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public void validate() {
        if (this.remediationDueDate() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property remediationDueDate in model GovernanceAssignmentProperties"));
        }
        if (this.remediationEta() != null) {
            this.remediationEta().validate();
        }
        if (this.governanceEmailNotification() != null) {
            this.governanceEmailNotification().validate();
        }
        if (this.additionalData() != null) {
            this.additionalData().validate();
        }
    }
}

