/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.GovernanceRuleEmailNotification;
import com.azure.resourcemanager.security.models.GovernanceRuleMetadata;
import com.azure.resourcemanager.security.models.GovernanceRuleOwnerSource;
import com.azure.resourcemanager.security.models.GovernanceRuleSourceResourceType;
import com.azure.resourcemanager.security.models.GovernanceRuleType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class GovernanceRuleProperties {
    @JsonProperty(value="tenantId", access=JsonProperty.Access.WRITE_ONLY)
    private String tenantId;
    @JsonProperty(value="displayName", required=true)
    private String displayName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="remediationTimeframe")
    private String remediationTimeframe;
    @JsonProperty(value="isGracePeriod")
    private Boolean isGracePeriod;
    @JsonProperty(value="rulePriority", required=true)
    private int rulePriority;
    @JsonProperty(value="isDisabled")
    private Boolean isDisabled;
    @JsonProperty(value="ruleType", required=true)
    private GovernanceRuleType ruleType;
    @JsonProperty(value="sourceResourceType", required=true)
    private GovernanceRuleSourceResourceType sourceResourceType;
    @JsonProperty(value="excludedScopes")
    private List<String> excludedScopes;
    @JsonProperty(value="conditionSets", required=true)
    private List<Object> conditionSets;
    @JsonProperty(value="includeMemberScopes")
    private Boolean includeMemberScopes;
    @JsonProperty(value="ownerSource", required=true)
    private GovernanceRuleOwnerSource ownerSource;
    @JsonProperty(value="governanceEmailNotification")
    private GovernanceRuleEmailNotification governanceEmailNotification;
    @JsonProperty(value="metadata")
    private GovernanceRuleMetadata metadata;
    private static final ClientLogger LOGGER = new ClientLogger(GovernanceRuleProperties.class);

    public String tenantId() {
        return this.tenantId;
    }

    public String displayName() {
        return this.displayName;
    }

    public GovernanceRuleProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public GovernanceRuleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String remediationTimeframe() {
        return this.remediationTimeframe;
    }

    public GovernanceRuleProperties withRemediationTimeframe(String remediationTimeframe) {
        this.remediationTimeframe = remediationTimeframe;
        return this;
    }

    public Boolean isGracePeriod() {
        return this.isGracePeriod;
    }

    public GovernanceRuleProperties withIsGracePeriod(Boolean isGracePeriod) {
        this.isGracePeriod = isGracePeriod;
        return this;
    }

    public int rulePriority() {
        return this.rulePriority;
    }

    public GovernanceRuleProperties withRulePriority(int rulePriority) {
        this.rulePriority = rulePriority;
        return this;
    }

    public Boolean isDisabled() {
        return this.isDisabled;
    }

    public GovernanceRuleProperties withIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    public GovernanceRuleType ruleType() {
        return this.ruleType;
    }

    public GovernanceRuleProperties withRuleType(GovernanceRuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    public GovernanceRuleSourceResourceType sourceResourceType() {
        return this.sourceResourceType;
    }

    public GovernanceRuleProperties withSourceResourceType(GovernanceRuleSourceResourceType sourceResourceType) {
        this.sourceResourceType = sourceResourceType;
        return this;
    }

    public List<String> excludedScopes() {
        return this.excludedScopes;
    }

    public GovernanceRuleProperties withExcludedScopes(List<String> excludedScopes) {
        this.excludedScopes = excludedScopes;
        return this;
    }

    public List<Object> conditionSets() {
        return this.conditionSets;
    }

    public GovernanceRuleProperties withConditionSets(List<Object> conditionSets) {
        this.conditionSets = conditionSets;
        return this;
    }

    public Boolean includeMemberScopes() {
        return this.includeMemberScopes;
    }

    public GovernanceRuleProperties withIncludeMemberScopes(Boolean includeMemberScopes) {
        this.includeMemberScopes = includeMemberScopes;
        return this;
    }

    public GovernanceRuleOwnerSource ownerSource() {
        return this.ownerSource;
    }

    public GovernanceRuleProperties withOwnerSource(GovernanceRuleOwnerSource ownerSource) {
        this.ownerSource = ownerSource;
        return this;
    }

    public GovernanceRuleEmailNotification governanceEmailNotification() {
        return this.governanceEmailNotification;
    }

    public GovernanceRuleProperties withGovernanceEmailNotification(GovernanceRuleEmailNotification governanceEmailNotification) {
        this.governanceEmailNotification = governanceEmailNotification;
        return this;
    }

    public GovernanceRuleMetadata metadata() {
        return this.metadata;
    }

    public GovernanceRuleProperties withMetadata(GovernanceRuleMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property displayName in model GovernanceRuleProperties"));
        }
        if (this.ruleType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ruleType in model GovernanceRuleProperties"));
        }
        if (this.sourceResourceType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceResourceType in model GovernanceRuleProperties"));
        }
        if (this.conditionSets() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property conditionSets in model GovernanceRuleProperties"));
        }
        if (this.ownerSource() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ownerSource in model GovernanceRuleProperties"));
        }
        this.ownerSource().validate();
        if (this.governanceEmailNotification() != null) {
            this.governanceEmailNotification().validate();
        }
        if (this.metadata() != null) {
            this.metadata().validate();
        }
    }
}

