/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.resourcemanager.security.models.IoTSecurityAlertedDevice;
import com.azure.resourcemanager.security.models.IoTSecurityDeviceAlert;
import com.azure.resourcemanager.security.models.IoTSecurityDeviceRecommendation;
import com.azure.resourcemanager.security.models.IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem;
import com.azure.resourcemanager.security.models.IoTSeverityMetrics;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class IoTSecuritySolutionAnalyticsModelProperties {
    @JsonProperty(value="metrics", access=JsonProperty.Access.WRITE_ONLY)
    private IoTSeverityMetrics metrics;
    @JsonProperty(value="unhealthyDeviceCount", access=JsonProperty.Access.WRITE_ONLY)
    private Long unhealthyDeviceCount;
    @JsonProperty(value="devicesMetrics", access=JsonProperty.Access.WRITE_ONLY)
    private List<IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem> devicesMetrics;
    @JsonProperty(value="topAlertedDevices")
    private List<IoTSecurityAlertedDevice> topAlertedDevices;
    @JsonProperty(value="mostPrevalentDeviceAlerts")
    private List<IoTSecurityDeviceAlert> mostPrevalentDeviceAlerts;
    @JsonProperty(value="mostPrevalentDeviceRecommendations")
    private List<IoTSecurityDeviceRecommendation> mostPrevalentDeviceRecommendations;

    public IoTSeverityMetrics metrics() {
        return this.metrics;
    }

    public Long unhealthyDeviceCount() {
        return this.unhealthyDeviceCount;
    }

    public List<IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem> devicesMetrics() {
        return this.devicesMetrics;
    }

    public List<IoTSecurityAlertedDevice> topAlertedDevices() {
        return this.topAlertedDevices;
    }

    public IoTSecuritySolutionAnalyticsModelProperties withTopAlertedDevices(List<IoTSecurityAlertedDevice> topAlertedDevices) {
        this.topAlertedDevices = topAlertedDevices;
        return this;
    }

    public List<IoTSecurityDeviceAlert> mostPrevalentDeviceAlerts() {
        return this.mostPrevalentDeviceAlerts;
    }

    public IoTSecuritySolutionAnalyticsModelProperties withMostPrevalentDeviceAlerts(List<IoTSecurityDeviceAlert> mostPrevalentDeviceAlerts) {
        this.mostPrevalentDeviceAlerts = mostPrevalentDeviceAlerts;
        return this;
    }

    public List<IoTSecurityDeviceRecommendation> mostPrevalentDeviceRecommendations() {
        return this.mostPrevalentDeviceRecommendations;
    }

    public IoTSecuritySolutionAnalyticsModelProperties withMostPrevalentDeviceRecommendations(List<IoTSecurityDeviceRecommendation> mostPrevalentDeviceRecommendations) {
        this.mostPrevalentDeviceRecommendations = mostPrevalentDeviceRecommendations;
        return this;
    }

    public void validate() {
        if (this.metrics() != null) {
            this.metrics().validate();
        }
        if (this.devicesMetrics() != null) {
            this.devicesMetrics().forEach(e -> e.validate());
        }
        if (this.topAlertedDevices() != null) {
            this.topAlertedDevices().forEach(e -> e.validate());
        }
        if (this.mostPrevalentDeviceAlerts() != null) {
            this.mostPrevalentDeviceAlerts().forEach(e -> e.validate());
        }
        if (this.mostPrevalentDeviceRecommendations() != null) {
            this.mostPrevalentDeviceRecommendations().forEach(e -> e.validate());
        }
    }
}

