/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.fluent.models.JitNetworkAccessPolicyProperties;
import com.azure.resourcemanager.security.fluent.models.JitNetworkAccessRequestInner;
import com.azure.resourcemanager.security.models.JitNetworkAccessPolicyVirtualMachine;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class JitNetworkAccessPolicyInner
extends ProxyResource {
    @JsonProperty(value="properties", required=true)
    private JitNetworkAccessPolicyProperties innerProperties = new JitNetworkAccessPolicyProperties();
    @JsonProperty(value="kind")
    private String kind;
    @JsonProperty(value="location", access=JsonProperty.Access.WRITE_ONLY)
    private String location;
    private static final ClientLogger LOGGER = new ClientLogger(JitNetworkAccessPolicyInner.class);

    private JitNetworkAccessPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String kind() {
        return this.kind;
    }

    public JitNetworkAccessPolicyInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String location() {
        return this.location;
    }

    public List<JitNetworkAccessPolicyVirtualMachine> virtualMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachines();
    }

    public JitNetworkAccessPolicyInner withVirtualMachines(List<JitNetworkAccessPolicyVirtualMachine> virtualMachines) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JitNetworkAccessPolicyProperties();
        }
        this.innerProperties().withVirtualMachines(virtualMachines);
        return this;
    }

    public List<JitNetworkAccessRequestInner> requests() {
        return this.innerProperties() == null ? null : this.innerProperties().requests();
    }

    public JitNetworkAccessPolicyInner withRequests(List<JitNetworkAccessRequestInner> requests) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JitNetworkAccessPolicyProperties();
        }
        this.innerProperties().withRequests(requests);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model JitNetworkAccessPolicyInner"));
        }
        this.innerProperties().validate();
    }
}

