/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.security.fluent.models.SecurityConnectorProperties;
import com.azure.resourcemanager.security.models.CloudName;
import com.azure.resourcemanager.security.models.CloudOffering;
import com.azure.resourcemanager.security.models.EnvironmentData;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class SecurityConnectorInner
extends Resource {
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="properties")
    private SecurityConnectorProperties innerProperties;

    public SystemData systemData() {
        return this.systemData;
    }

    private SecurityConnectorProperties innerProperties() {
        return this.innerProperties;
    }

    public SecurityConnectorInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SecurityConnectorInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String hierarchyIdentifier() {
        return this.innerProperties() == null ? null : this.innerProperties().hierarchyIdentifier();
    }

    public SecurityConnectorInner withHierarchyIdentifier(String hierarchyIdentifier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityConnectorProperties();
        }
        this.innerProperties().withHierarchyIdentifier(hierarchyIdentifier);
        return this;
    }

    public OffsetDateTime hierarchyIdentifierTrialEndDate() {
        return this.innerProperties() == null ? null : this.innerProperties().hierarchyIdentifierTrialEndDate();
    }

    public CloudName environmentName() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentName();
    }

    public SecurityConnectorInner withEnvironmentName(CloudName environmentName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityConnectorProperties();
        }
        this.innerProperties().withEnvironmentName(environmentName);
        return this;
    }

    public List<CloudOffering> offerings() {
        return this.innerProperties() == null ? null : this.innerProperties().offerings();
    }

    public SecurityConnectorInner withOfferings(List<CloudOffering> offerings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityConnectorProperties();
        }
        this.innerProperties().withOfferings(offerings);
        return this;
    }

    public EnvironmentData environmentData() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentData();
    }

    public SecurityConnectorInner withEnvironmentData(EnvironmentData environmentData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityConnectorProperties();
        }
        this.innerProperties().withEnvironmentData(environmentData);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

