/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.AdaptiveNetworkHardeningsClient;
import com.azure.resourcemanager.security.fluent.models.AdaptiveNetworkHardeningInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.AdaptiveNetworkHardeningEnforceRequest;
import com.azure.resourcemanager.security.models.AdaptiveNetworkHardeningsList;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AdaptiveNetworkHardeningsClientImpl
implements AdaptiveNetworkHardeningsClient {
    private final AdaptiveNetworkHardeningsService service;
    private final SecurityCenterImpl client;

    AdaptiveNetworkHardeningsClientImpl(SecurityCenterImpl client) {
        this.service = (AdaptiveNetworkHardeningsService)RestProxy.create(AdaptiveNetworkHardeningsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AdaptiveNetworkHardeningInner>> listByExtendedResourceSinglePageAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByExtendedResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "2020-01-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AdaptiveNetworkHardeningsList)res.getValue()).value(), ((AdaptiveNetworkHardeningsList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AdaptiveNetworkHardeningInner>> listByExtendedResourceSinglePageAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByExtendedResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "2020-01-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AdaptiveNetworkHardeningsList)res.getValue()).value(), ((AdaptiveNetworkHardeningsList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AdaptiveNetworkHardeningInner> listByExtendedResourceAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return new PagedFlux(() -> this.listByExtendedResourceSinglePageAsync(resourceGroupName, resourceNamespace, resourceType, resourceName), nextLink -> this.listByExtendedResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AdaptiveNetworkHardeningInner> listByExtendedResourceAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        return new PagedFlux(() -> this.listByExtendedResourceSinglePageAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, context), nextLink -> this.listByExtendedResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AdaptiveNetworkHardeningInner> listByExtendedResource(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return new PagedIterable(this.listByExtendedResourceAsync(resourceGroupName, resourceNamespace, resourceType, resourceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AdaptiveNetworkHardeningInner> listByExtendedResource(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        return new PagedIterable(this.listByExtendedResourceAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdaptiveNetworkHardeningInner>> getWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (adaptiveNetworkHardeningResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter adaptiveNetworkHardeningResourceName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, "2020-01-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdaptiveNetworkHardeningInner>> getWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (adaptiveNetworkHardeningResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter adaptiveNetworkHardeningResourceName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, "2020-01-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AdaptiveNetworkHardeningInner> getAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName) {
        return this.getWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AdaptiveNetworkHardeningInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdaptiveNetworkHardeningInner> getWithResponse(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdaptiveNetworkHardeningInner get(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName) {
        return (AdaptiveNetworkHardeningInner)((Object)this.getWithResponse(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> enforceWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (adaptiveNetworkHardeningResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter adaptiveNetworkHardeningResourceName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String adaptiveNetworkHardeningEnforceAction = "enforce";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enforce(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, "enforce", "2020-01-01", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> enforceWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (adaptiveNetworkHardeningResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter adaptiveNetworkHardeningResourceName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String adaptiveNetworkHardeningEnforceAction = "enforce";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.enforce(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, "enforce", "2020-01-01", body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginEnforceAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.enforceWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginEnforceAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.enforceWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginEnforce(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body) {
        return this.beginEnforceAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginEnforce(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body, Context context) {
        return this.beginEnforceAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> enforceAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body) {
        return this.beginEnforceAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> enforceAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body, Context context) {
        return this.beginEnforceAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enforce(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body) {
        this.enforceAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enforce(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String adaptiveNetworkHardeningResourceName, AdaptiveNetworkHardeningEnforceRequest body, Context context) {
        this.enforceAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AdaptiveNetworkHardeningInner>> listByExtendedResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByExtendedResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AdaptiveNetworkHardeningsList)res.getValue()).value(), ((AdaptiveNetworkHardeningsList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AdaptiveNetworkHardeningInner>> listByExtendedResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByExtendedResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AdaptiveNetworkHardeningsList)res.getValue()).value(), ((AdaptiveNetworkHardeningsList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterAdapti")
    public static interface AdaptiveNetworkHardeningsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdaptiveNetworkHardeningsList>> listByExtendedResource(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceNamespace") String var4, @PathParam(value="resourceType") String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings/{adaptiveNetworkHardeningResourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdaptiveNetworkHardeningInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceNamespace") String var4, @PathParam(value="resourceType") String var5, @PathParam(value="resourceName") String var6, @PathParam(value="adaptiveNetworkHardeningResourceName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings/{adaptiveNetworkHardeningResourceName}/{adaptiveNetworkHardeningEnforceAction}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> enforce(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceNamespace") String var4, @PathParam(value="resourceType") String var5, @PathParam(value="resourceName") String var6, @PathParam(value="adaptiveNetworkHardeningResourceName") String var7, @PathParam(value="adaptiveNetworkHardeningEnforceAction") String var8, @QueryParam(value="api-version") String var9, @BodyParam(value="application/json") AdaptiveNetworkHardeningEnforceRequest var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdaptiveNetworkHardeningsList>> listByExtendedResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

