/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.AlertsClient;
import com.azure.resourcemanager.security.fluent.models.AlertInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.AlertList;
import com.azure.resourcemanager.security.models.AlertSimulatorRequestBody;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AlertsClientImpl
implements AlertsClient {
    private final AlertsService service;
    private final SecurityCenterImpl client;

    AlertsClientImpl(SecurityCenterImpl client) {
        this.service = (AlertsService)RestProxy.create(AlertsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listSubscriptionLevelByRegionSinglePageAsync(String ascLocation) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSubscriptionLevelByRegion(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listSubscriptionLevelByRegionSinglePageAsync(String ascLocation, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSubscriptionLevelByRegion(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertInner> listSubscriptionLevelByRegionAsync(String ascLocation) {
        return new PagedFlux(() -> this.listSubscriptionLevelByRegionSinglePageAsync(ascLocation), nextLink -> this.listSubscriptionLevelByRegionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertInner> listSubscriptionLevelByRegionAsync(String ascLocation, Context context) {
        return new PagedFlux(() -> this.listSubscriptionLevelByRegionSinglePageAsync(ascLocation, context), nextLink -> this.listSubscriptionLevelByRegionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertInner> listSubscriptionLevelByRegion(String ascLocation) {
        return new PagedIterable(this.listSubscriptionLevelByRegionAsync(ascLocation));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertInner> listSubscriptionLevelByRegion(String ascLocation, Context context) {
        return new PagedIterable(this.listSubscriptionLevelByRegionAsync(ascLocation, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listResourceGroupLevelByRegionSinglePageAsync(String ascLocation, String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listResourceGroupLevelByRegion(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listResourceGroupLevelByRegionSinglePageAsync(String ascLocation, String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listResourceGroupLevelByRegion(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, resourceGroupName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertInner> listResourceGroupLevelByRegionAsync(String ascLocation, String resourceGroupName) {
        return new PagedFlux(() -> this.listResourceGroupLevelByRegionSinglePageAsync(ascLocation, resourceGroupName), nextLink -> this.listResourceGroupLevelByRegionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertInner> listResourceGroupLevelByRegionAsync(String ascLocation, String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listResourceGroupLevelByRegionSinglePageAsync(ascLocation, resourceGroupName, context), nextLink -> this.listResourceGroupLevelByRegionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertInner> listResourceGroupLevelByRegion(String ascLocation, String resourceGroupName) {
        return new PagedIterable(this.listResourceGroupLevelByRegionAsync(ascLocation, resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertInner> listResourceGroupLevelByRegion(String ascLocation, String resourceGroupName, Context context) {
        return new PagedIterable(this.listResourceGroupLevelByRegionAsync(ascLocation, resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertInner>> getSubscriptionLevelWithResponseAsync(String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSubscriptionLevel(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertInner>> getSubscriptionLevelWithResponseAsync(String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSubscriptionLevel(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AlertInner> getSubscriptionLevelAsync(String ascLocation, String alertName) {
        return this.getSubscriptionLevelWithResponseAsync(ascLocation, alertName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AlertInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AlertInner> getSubscriptionLevelWithResponse(String ascLocation, String alertName, Context context) {
        return (Response)this.getSubscriptionLevelWithResponseAsync(ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AlertInner getSubscriptionLevel(String ascLocation, String alertName) {
        return (AlertInner)((Object)this.getSubscriptionLevelWithResponse(ascLocation, alertName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertInner>> getResourceGroupLevelWithResponseAsync(String resourceGroupName, String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getResourceGroupLevel(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertInner>> getResourceGroupLevelWithResponseAsync(String resourceGroupName, String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getResourceGroupLevel(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AlertInner> getResourceGroupLevelAsync(String resourceGroupName, String ascLocation, String alertName) {
        return this.getResourceGroupLevelWithResponseAsync(resourceGroupName, ascLocation, alertName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AlertInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AlertInner> getResourceGroupLevelWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        return (Response)this.getResourceGroupLevelWithResponseAsync(resourceGroupName, ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AlertInner getResourceGroupLevel(String resourceGroupName, String ascLocation, String alertName) {
        return (AlertInner)((Object)this.getResourceGroupLevelWithResponse(resourceGroupName, ascLocation, alertName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelStateToDismissWithResponseAsync(String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSubscriptionLevelStateToDismiss(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelStateToDismissWithResponseAsync(String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSubscriptionLevelStateToDismiss(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateSubscriptionLevelStateToDismissAsync(String ascLocation, String alertName) {
        return this.updateSubscriptionLevelStateToDismissWithResponseAsync(ascLocation, alertName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateSubscriptionLevelStateToDismissWithResponse(String ascLocation, String alertName, Context context) {
        return (Response)this.updateSubscriptionLevelStateToDismissWithResponseAsync(ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateSubscriptionLevelStateToDismiss(String ascLocation, String alertName) {
        this.updateSubscriptionLevelStateToDismissWithResponse(ascLocation, alertName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelStateToResolveWithResponseAsync(String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSubscriptionLevelStateToResolve(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelStateToResolveWithResponseAsync(String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSubscriptionLevelStateToResolve(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateSubscriptionLevelStateToResolveAsync(String ascLocation, String alertName) {
        return this.updateSubscriptionLevelStateToResolveWithResponseAsync(ascLocation, alertName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateSubscriptionLevelStateToResolveWithResponse(String ascLocation, String alertName, Context context) {
        return (Response)this.updateSubscriptionLevelStateToResolveWithResponseAsync(ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateSubscriptionLevelStateToResolve(String ascLocation, String alertName) {
        this.updateSubscriptionLevelStateToResolveWithResponse(ascLocation, alertName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelStateToActivateWithResponseAsync(String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSubscriptionLevelStateToActivate(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelStateToActivateWithResponseAsync(String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSubscriptionLevelStateToActivate(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateSubscriptionLevelStateToActivateAsync(String ascLocation, String alertName) {
        return this.updateSubscriptionLevelStateToActivateWithResponseAsync(ascLocation, alertName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateSubscriptionLevelStateToActivateWithResponse(String ascLocation, String alertName, Context context) {
        return (Response)this.updateSubscriptionLevelStateToActivateWithResponseAsync(ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateSubscriptionLevelStateToActivate(String ascLocation, String alertName) {
        this.updateSubscriptionLevelStateToActivateWithResponse(ascLocation, alertName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelStateToInProgressWithResponseAsync(String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSubscriptionLevelStateToInProgress(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelStateToInProgressWithResponseAsync(String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSubscriptionLevelStateToInProgress(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateSubscriptionLevelStateToInProgressAsync(String ascLocation, String alertName) {
        return this.updateSubscriptionLevelStateToInProgressWithResponseAsync(ascLocation, alertName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateSubscriptionLevelStateToInProgressWithResponse(String ascLocation, String alertName, Context context) {
        return (Response)this.updateSubscriptionLevelStateToInProgressWithResponseAsync(ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateSubscriptionLevelStateToInProgress(String ascLocation, String alertName) {
        this.updateSubscriptionLevelStateToInProgressWithResponse(ascLocation, alertName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelStateToResolveWithResponseAsync(String resourceGroupName, String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateResourceGroupLevelStateToResolve(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelStateToResolveWithResponseAsync(String resourceGroupName, String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateResourceGroupLevelStateToResolve(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateResourceGroupLevelStateToResolveAsync(String resourceGroupName, String ascLocation, String alertName) {
        return this.updateResourceGroupLevelStateToResolveWithResponseAsync(resourceGroupName, ascLocation, alertName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateResourceGroupLevelStateToResolveWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        return (Response)this.updateResourceGroupLevelStateToResolveWithResponseAsync(resourceGroupName, ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateResourceGroupLevelStateToResolve(String resourceGroupName, String ascLocation, String alertName) {
        this.updateResourceGroupLevelStateToResolveWithResponse(resourceGroupName, ascLocation, alertName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelStateToDismissWithResponseAsync(String resourceGroupName, String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateResourceGroupLevelStateToDismiss(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelStateToDismissWithResponseAsync(String resourceGroupName, String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateResourceGroupLevelStateToDismiss(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateResourceGroupLevelStateToDismissAsync(String resourceGroupName, String ascLocation, String alertName) {
        return this.updateResourceGroupLevelStateToDismissWithResponseAsync(resourceGroupName, ascLocation, alertName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateResourceGroupLevelStateToDismissWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        return (Response)this.updateResourceGroupLevelStateToDismissWithResponseAsync(resourceGroupName, ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateResourceGroupLevelStateToDismiss(String resourceGroupName, String ascLocation, String alertName) {
        this.updateResourceGroupLevelStateToDismissWithResponse(resourceGroupName, ascLocation, alertName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelStateToActivateWithResponseAsync(String resourceGroupName, String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateResourceGroupLevelStateToActivate(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelStateToActivateWithResponseAsync(String resourceGroupName, String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateResourceGroupLevelStateToActivate(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateResourceGroupLevelStateToActivateAsync(String resourceGroupName, String ascLocation, String alertName) {
        return this.updateResourceGroupLevelStateToActivateWithResponseAsync(resourceGroupName, ascLocation, alertName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateResourceGroupLevelStateToActivateWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        return (Response)this.updateResourceGroupLevelStateToActivateWithResponseAsync(resourceGroupName, ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateResourceGroupLevelStateToActivate(String resourceGroupName, String ascLocation, String alertName) {
        this.updateResourceGroupLevelStateToActivateWithResponse(resourceGroupName, ascLocation, alertName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelStateToInProgressWithResponseAsync(String resourceGroupName, String ascLocation, String alertName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateResourceGroupLevelStateToInProgress(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelStateToInProgressWithResponseAsync(String resourceGroupName, String ascLocation, String alertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateResourceGroupLevelStateToInProgress(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, ascLocation, alertName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateResourceGroupLevelStateToInProgressAsync(String resourceGroupName, String ascLocation, String alertName) {
        return this.updateResourceGroupLevelStateToInProgressWithResponseAsync(resourceGroupName, ascLocation, alertName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateResourceGroupLevelStateToInProgressWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        return (Response)this.updateResourceGroupLevelStateToInProgressWithResponseAsync(resourceGroupName, ascLocation, alertName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateResourceGroupLevelStateToInProgress(String resourceGroupName, String ascLocation, String alertName) {
        this.updateResourceGroupLevelStateToInProgressWithResponse(resourceGroupName, ascLocation, alertName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> simulateWithResponseAsync(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertSimulatorRequestBody == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertSimulatorRequestBody is required and cannot be null."));
        }
        alertSimulatorRequestBody.validate();
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.simulate(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertSimulatorRequestBody, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> simulateWithResponseAsync(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (alertSimulatorRequestBody == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertSimulatorRequestBody is required and cannot be null."));
        }
        alertSimulatorRequestBody.validate();
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.simulate(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), ascLocation, alertSimulatorRequestBody, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginSimulateAsync(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.simulateWithResponseAsync(ascLocation, alertSimulatorRequestBody);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginSimulateAsync(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.simulateWithResponseAsync(ascLocation, alertSimulatorRequestBody, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginSimulate(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody) {
        return this.beginSimulateAsync(ascLocation, alertSimulatorRequestBody).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginSimulate(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody, Context context) {
        return this.beginSimulateAsync(ascLocation, alertSimulatorRequestBody, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> simulateAsync(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody) {
        return this.beginSimulateAsync(ascLocation, alertSimulatorRequestBody).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> simulateAsync(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody, Context context) {
        return this.beginSimulateAsync(ascLocation, alertSimulatorRequestBody, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void simulate(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody) {
        this.simulateAsync(ascLocation, alertSimulatorRequestBody).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void simulate(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody, Context context) {
        this.simulateAsync(ascLocation, alertSimulatorRequestBody, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listSubscriptionLevelByRegionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSubscriptionLevelByRegionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listSubscriptionLevelByRegionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSubscriptionLevelByRegionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listResourceGroupLevelByRegionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listResourceGroupLevelByRegionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertInner>> listResourceGroupLevelByRegionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listResourceGroupLevelByRegionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertList)res.getValue()).value(), ((AlertList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterAlerts")
    public static interface AlertsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/alerts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/alerts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertList>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertList>> listSubscriptionLevelByRegion(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertList>> listResourceGroupLevelByRegion(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="resourceGroupName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertInner>> getSubscriptionLevel(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="alertName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertInner>> getResourceGroupLevel(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="ascLocation") String var5, @PathParam(value="alertName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/dismiss")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateSubscriptionLevelStateToDismiss(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="alertName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/resolve")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateSubscriptionLevelStateToResolve(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="alertName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/activate")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateSubscriptionLevelStateToActivate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="alertName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/inProgress")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateSubscriptionLevelStateToInProgress(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="alertName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/resolve")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateResourceGroupLevelStateToResolve(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="ascLocation") String var5, @PathParam(value="alertName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/dismiss")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateResourceGroupLevelStateToDismiss(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="ascLocation") String var5, @PathParam(value="alertName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/activate")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateResourceGroupLevelStateToActivate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="ascLocation") String var5, @PathParam(value="alertName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/inProgress")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateResourceGroupLevelStateToInProgress(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="ascLocation") String var5, @PathParam(value="alertName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/default/simulate")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> simulate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @BodyParam(value="application/json") AlertSimulatorRequestBody var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertList>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertList>> listSubscriptionLevelByRegionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertList>> listResourceGroupLevelByRegionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

