/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AllowedConnectionsClient;
import com.azure.resourcemanager.security.fluent.models.AllowedConnectionsResourceInner;
import com.azure.resourcemanager.security.implementation.AllowedConnectionsResourceImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AllowedConnections;
import com.azure.resourcemanager.security.models.AllowedConnectionsResource;
import com.azure.resourcemanager.security.models.ConnectionType;

public final class AllowedConnectionsImpl
implements AllowedConnections {
    private static final ClientLogger LOGGER = new ClientLogger(AllowedConnectionsImpl.class);
    private final AllowedConnectionsClient innerClient;
    private final SecurityManager serviceManager;

    public AllowedConnectionsImpl(AllowedConnectionsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AllowedConnectionsResource> list() {
        PagedIterable<AllowedConnectionsResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AllowedConnectionsResourceImpl((AllowedConnectionsResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AllowedConnectionsResource> list(Context context) {
        PagedIterable<AllowedConnectionsResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AllowedConnectionsResourceImpl((AllowedConnectionsResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AllowedConnectionsResource> listByHomeRegion(String ascLocation) {
        PagedIterable<AllowedConnectionsResourceInner> inner = this.serviceClient().listByHomeRegion(ascLocation);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AllowedConnectionsResourceImpl((AllowedConnectionsResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AllowedConnectionsResource> listByHomeRegion(String ascLocation, Context context) {
        PagedIterable<AllowedConnectionsResourceInner> inner = this.serviceClient().listByHomeRegion(ascLocation, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AllowedConnectionsResourceImpl((AllowedConnectionsResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AllowedConnectionsResource> getWithResponse(String resourceGroupName, String ascLocation, ConnectionType connectionType, Context context) {
        Response<AllowedConnectionsResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, ascLocation, connectionType, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AllowedConnectionsResourceImpl((AllowedConnectionsResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AllowedConnectionsResource get(String resourceGroupName, String ascLocation, ConnectionType connectionType) {
        AllowedConnectionsResourceInner inner = this.serviceClient().get(resourceGroupName, ascLocation, connectionType);
        if (inner != null) {
            return new AllowedConnectionsResourceImpl(inner, this.manager());
        }
        return null;
    }

    private AllowedConnectionsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

