/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.ApiCollectionsClient;
import com.azure.resourcemanager.security.fluent.models.ApiCollectionInner;
import com.azure.resourcemanager.security.implementation.ApiCollectionImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.ApiCollection;
import com.azure.resourcemanager.security.models.ApiCollections;

public final class ApiCollectionsImpl
implements ApiCollections {
    private static final ClientLogger LOGGER = new ClientLogger(ApiCollectionsImpl.class);
    private final ApiCollectionsClient innerClient;
    private final SecurityManager serviceManager;

    public ApiCollectionsImpl(ApiCollectionsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiCollection> list() {
        PagedIterable<ApiCollectionInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiCollectionImpl((ApiCollectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiCollection> list(Context context) {
        PagedIterable<ApiCollectionInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiCollectionImpl((ApiCollectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiCollection> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ApiCollectionInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiCollectionImpl((ApiCollectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiCollection> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ApiCollectionInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiCollectionImpl((ApiCollectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiCollection> listByAzureApiManagementService(String resourceGroupName, String serviceName) {
        PagedIterable<ApiCollectionInner> inner = this.serviceClient().listByAzureApiManagementService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiCollectionImpl((ApiCollectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiCollection> listByAzureApiManagementService(String resourceGroupName, String serviceName, Context context) {
        PagedIterable<ApiCollectionInner> inner = this.serviceClient().listByAzureApiManagementService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiCollectionImpl((ApiCollectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ApiCollection> getByAzureApiManagementServiceWithResponse(String resourceGroupName, String serviceName, String apiId, Context context) {
        Response<ApiCollectionInner> inner = this.serviceClient().getByAzureApiManagementServiceWithResponse(resourceGroupName, serviceName, apiId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiCollectionImpl((ApiCollectionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ApiCollection getByAzureApiManagementService(String resourceGroupName, String serviceName, String apiId) {
        ApiCollectionInner inner = this.serviceClient().getByAzureApiManagementService(resourceGroupName, serviceName, apiId);
        if (inner != null) {
            return new ApiCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiCollection onboardAzureApiManagementApi(String resourceGroupName, String serviceName, String apiId) {
        ApiCollectionInner inner = this.serviceClient().onboardAzureApiManagementApi(resourceGroupName, serviceName, apiId);
        if (inner != null) {
            return new ApiCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiCollection onboardAzureApiManagementApi(String resourceGroupName, String serviceName, String apiId, Context context) {
        ApiCollectionInner inner = this.serviceClient().onboardAzureApiManagementApi(resourceGroupName, serviceName, apiId, context);
        if (inner != null) {
            return new ApiCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> offboardAzureApiManagementApiWithResponse(String resourceGroupName, String serviceName, String apiId, Context context) {
        return this.serviceClient().offboardAzureApiManagementApiWithResponse(resourceGroupName, serviceName, apiId, context);
    }

    @Override
    public void offboardAzureApiManagementApi(String resourceGroupName, String serviceName, String apiId) {
        this.serviceClient().offboardAzureApiManagementApi(resourceGroupName, serviceName, apiId);
    }

    private ApiCollectionsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

