/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.ApplicationOperationsClient;
import com.azure.resourcemanager.security.fluent.models.ApplicationInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class ApplicationOperationsClientImpl
implements ApplicationOperationsClient {
    private final ApplicationOperationsService service;
    private final SecurityCenterImpl client;

    ApplicationOperationsClientImpl(SecurityCenterImpl client) {
        this.service = (ApplicationOperationsService)RestProxy.create(ApplicationOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationInner>> getWithResponseAsync(String applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String apiVersion = "2022-07-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2022-07-01-preview", this.client.getSubscriptionId(), applicationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationInner>> getWithResponseAsync(String applicationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String apiVersion = "2022-07-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2022-07-01-preview", this.client.getSubscriptionId(), applicationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApplicationInner> getAsync(String applicationId) {
        return this.getWithResponseAsync(applicationId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ApplicationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApplicationInner> getWithResponse(String applicationId, Context context) {
        return (Response)this.getWithResponseAsync(applicationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationInner get(String applicationId) {
        return (ApplicationInner)((Object)this.getWithResponse(applicationId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationInner>> createOrUpdateWithResponseAsync(String applicationId, ApplicationInner application) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (application == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter application is required and cannot be null."));
        }
        application.validate();
        String apiVersion = "2022-07-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2022-07-01-preview", this.client.getSubscriptionId(), applicationId, application, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationInner>> createOrUpdateWithResponseAsync(String applicationId, ApplicationInner application, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (application == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter application is required and cannot be null."));
        }
        application.validate();
        String apiVersion = "2022-07-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2022-07-01-preview", this.client.getSubscriptionId(), applicationId, application, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApplicationInner> createOrUpdateAsync(String applicationId, ApplicationInner application) {
        return this.createOrUpdateWithResponseAsync(applicationId, application).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ApplicationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApplicationInner> createOrUpdateWithResponse(String applicationId, ApplicationInner application, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(applicationId, application, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationInner createOrUpdate(String applicationId, ApplicationInner application) {
        return (ApplicationInner)((Object)this.createOrUpdateWithResponse(applicationId, application, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String apiVersion = "2022-07-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2022-07-01-preview", this.client.getSubscriptionId(), applicationId, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String applicationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String apiVersion = "2022-07-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2022-07-01-preview", this.client.getSubscriptionId(), applicationId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String applicationId) {
        return this.deleteWithResponseAsync(applicationId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String applicationId, Context context) {
        return (Response)this.deleteWithResponseAsync(applicationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String applicationId) {
        this.deleteWithResponse(applicationId, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterApplic")
    public static interface ApplicationOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/applications/{applicationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="applicationId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/applications/{applicationId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="applicationId") String var4, @BodyParam(value="application/json") ApplicationInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/applications/{applicationId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="applicationId") String var4, Context var5);
    }
}

