/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.ApplicationsClient;
import com.azure.resourcemanager.security.fluent.models.ApplicationInner;
import com.azure.resourcemanager.security.implementation.ApplicationImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.Application;
import com.azure.resourcemanager.security.models.Applications;

public final class ApplicationsImpl
implements Applications {
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationsImpl.class);
    private final ApplicationsClient innerClient;
    private final SecurityManager serviceManager;

    public ApplicationsImpl(ApplicationsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Application> list() {
        PagedIterable<ApplicationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApplicationImpl((ApplicationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Application> list(Context context) {
        PagedIterable<ApplicationInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApplicationImpl((ApplicationInner)((Object)inner1), this.manager()));
    }

    private ApplicationsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

