/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AssessmentsClient;
import com.azure.resourcemanager.security.fluent.models.SecurityAssessmentResponseInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SecurityAssessmentResponseImpl;
import com.azure.resourcemanager.security.models.Assessments;
import com.azure.resourcemanager.security.models.ExpandEnum;
import com.azure.resourcemanager.security.models.SecurityAssessmentResponse;

public final class AssessmentsImpl
implements Assessments {
    private static final ClientLogger LOGGER = new ClientLogger(AssessmentsImpl.class);
    private final AssessmentsClient innerClient;
    private final SecurityManager serviceManager;

    public AssessmentsImpl(AssessmentsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SecurityAssessmentResponse> list(String scope) {
        PagedIterable<SecurityAssessmentResponseInner> inner = this.serviceClient().list(scope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityAssessmentResponseImpl((SecurityAssessmentResponseInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecurityAssessmentResponse> list(String scope, Context context) {
        PagedIterable<SecurityAssessmentResponseInner> inner = this.serviceClient().list(scope, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityAssessmentResponseImpl((SecurityAssessmentResponseInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SecurityAssessmentResponse> getWithResponse(String resourceId, String assessmentName, ExpandEnum expand, Context context) {
        Response<SecurityAssessmentResponseInner> inner = this.serviceClient().getWithResponse(resourceId, assessmentName, expand, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecurityAssessmentResponseImpl((SecurityAssessmentResponseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecurityAssessmentResponse get(String resourceId, String assessmentName) {
        SecurityAssessmentResponseInner inner = this.serviceClient().get(resourceId, assessmentName);
        if (inner != null) {
            return new SecurityAssessmentResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceId, String assessmentName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceId, assessmentName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceId, String assessmentName) {
        this.serviceClient().delete(resourceId, assessmentName);
    }

    @Override
    public SecurityAssessmentResponse getById(String id) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "assessmentName");
        if (assessmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessments'.", id)));
        }
        ExpandEnum localExpand = null;
        return (SecurityAssessmentResponse)this.getWithResponse(resourceId, assessmentName, localExpand, Context.NONE).getValue();
    }

    @Override
    public Response<SecurityAssessmentResponse> getByIdWithResponse(String id, ExpandEnum expand, Context context) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "assessmentName");
        if (assessmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessments'.", id)));
        }
        return this.getWithResponse(resourceId, assessmentName, expand, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "assessmentName");
        if (assessmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessments'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceId, assessmentName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "assessmentName");
        if (assessmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessments'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceId, assessmentName, context);
    }

    private AssessmentsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityAssessmentResponseImpl define(String name) {
        return new SecurityAssessmentResponseImpl(name, this.manager());
    }
}

