/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AutoProvisioningSettingsClient;
import com.azure.resourcemanager.security.fluent.models.AutoProvisioningSettingInner;
import com.azure.resourcemanager.security.implementation.AutoProvisioningSettingImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AutoProvisioningSetting;
import com.azure.resourcemanager.security.models.AutoProvisioningSettings;

public final class AutoProvisioningSettingsImpl
implements AutoProvisioningSettings {
    private static final ClientLogger LOGGER = new ClientLogger(AutoProvisioningSettingsImpl.class);
    private final AutoProvisioningSettingsClient innerClient;
    private final SecurityManager serviceManager;

    public AutoProvisioningSettingsImpl(AutoProvisioningSettingsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AutoProvisioningSetting> list() {
        PagedIterable<AutoProvisioningSettingInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutoProvisioningSettingImpl((AutoProvisioningSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AutoProvisioningSetting> list(Context context) {
        PagedIterable<AutoProvisioningSettingInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutoProvisioningSettingImpl((AutoProvisioningSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AutoProvisioningSetting> getWithResponse(String settingName, Context context) {
        Response<AutoProvisioningSettingInner> inner = this.serviceClient().getWithResponse(settingName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AutoProvisioningSettingImpl((AutoProvisioningSettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AutoProvisioningSetting get(String settingName) {
        AutoProvisioningSettingInner inner = this.serviceClient().get(settingName);
        if (inner != null) {
            return new AutoProvisioningSettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AutoProvisioningSetting getById(String id) {
        String settingName = ResourceManagerUtils.getValueFromIdByName(id, "autoProvisioningSettings");
        if (settingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoProvisioningSettings'.", id)));
        }
        return (AutoProvisioningSetting)this.getWithResponse(settingName, Context.NONE).getValue();
    }

    @Override
    public Response<AutoProvisioningSetting> getByIdWithResponse(String id, Context context) {
        String settingName = ResourceManagerUtils.getValueFromIdByName(id, "autoProvisioningSettings");
        if (settingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoProvisioningSettings'.", id)));
        }
        return this.getWithResponse(settingName, context);
    }

    private AutoProvisioningSettingsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutoProvisioningSettingImpl define(String name) {
        return new AutoProvisioningSettingImpl(name, this.manager());
    }
}

