/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.AutomationInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.Automation;
import com.azure.resourcemanager.security.models.AutomationAction;
import com.azure.resourcemanager.security.models.AutomationScope;
import com.azure.resourcemanager.security.models.AutomationSource;
import com.azure.resourcemanager.security.models.AutomationUpdateModel;
import com.azure.resourcemanager.security.models.AutomationValidationStatus;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class AutomationImpl
implements Automation,
Automation.Definition,
Automation.Update {
    private AutomationInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceGroupName;
    private String automationName;
    private AutomationUpdateModel updateAutomation;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Boolean isEnabled() {
        return this.innerModel().isEnabled();
    }

    @Override
    public List<AutomationScope> scopes() {
        List<AutomationScope> inner = this.innerModel().scopes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<AutomationSource> sources() {
        List<AutomationSource> inner = this.innerModel().sources();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<AutomationAction> actions() {
        List<AutomationAction> inner = this.innerModel().actions();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AutomationInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutomationImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Automation create() {
        this.innerObject = (AutomationInner)((Object)this.serviceManager.serviceClient().getAutomations().createOrUpdateWithResponse(this.resourceGroupName, this.automationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Automation create(Context context) {
        this.innerObject = (AutomationInner)((Object)this.serviceManager.serviceClient().getAutomations().createOrUpdateWithResponse(this.resourceGroupName, this.automationName, this.innerModel(), context).getValue());
        return this;
    }

    AutomationImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new AutomationInner();
        this.serviceManager = serviceManager;
        this.automationName = name;
    }

    @Override
    public AutomationImpl update() {
        this.updateAutomation = new AutomationUpdateModel();
        return this;
    }

    @Override
    public Automation apply() {
        this.innerObject = (AutomationInner)((Object)this.serviceManager.serviceClient().getAutomations().updateWithResponse(this.resourceGroupName, this.automationName, this.updateAutomation, Context.NONE).getValue());
        return this;
    }

    @Override
    public Automation apply(Context context) {
        this.innerObject = (AutomationInner)((Object)this.serviceManager.serviceClient().getAutomations().updateWithResponse(this.resourceGroupName, this.automationName, this.updateAutomation, context).getValue());
        return this;
    }

    AutomationImpl(AutomationInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automations");
    }

    @Override
    public Automation refresh() {
        this.innerObject = (AutomationInner)((Object)this.serviceManager.serviceClient().getAutomations().getByResourceGroupWithResponse(this.resourceGroupName, this.automationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Automation refresh(Context context) {
        this.innerObject = (AutomationInner)((Object)this.serviceManager.serviceClient().getAutomations().getByResourceGroupWithResponse(this.resourceGroupName, this.automationName, context).getValue());
        return this;
    }

    @Override
    public Response<AutomationValidationStatus> validateWithResponse(AutomationInner automation, Context context) {
        return this.serviceManager.automations().validateWithResponse(this.resourceGroupName, this.automationName, automation, context);
    }

    @Override
    public AutomationValidationStatus validate(AutomationInner automation) {
        return this.serviceManager.automations().validate(this.resourceGroupName, this.automationName, automation);
    }

    @Override
    public AutomationImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public AutomationImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public AutomationImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateAutomation.withTags((Map)tags);
        return this;
    }

    @Override
    public AutomationImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateAutomation.withDescription(description);
        return this;
    }

    @Override
    public AutomationImpl withIsEnabled(Boolean isEnabled) {
        if (this.isInCreateMode()) {
            this.innerModel().withIsEnabled(isEnabled);
            return this;
        }
        this.updateAutomation.withIsEnabled(isEnabled);
        return this;
    }

    @Override
    public AutomationImpl withScopes(List<AutomationScope> scopes) {
        if (this.isInCreateMode()) {
            this.innerModel().withScopes(scopes);
            return this;
        }
        this.updateAutomation.withScopes(scopes);
        return this;
    }

    @Override
    public AutomationImpl withSources(List<AutomationSource> sources) {
        if (this.isInCreateMode()) {
            this.innerModel().withSources(sources);
            return this;
        }
        this.updateAutomation.withSources(sources);
        return this;
    }

    @Override
    public AutomationImpl withActions(List<AutomationAction> actions) {
        if (this.isInCreateMode()) {
            this.innerModel().withActions(actions);
            return this;
        }
        this.updateAutomation.withActions(actions);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

