/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AutomationsClient;
import com.azure.resourcemanager.security.fluent.models.AutomationInner;
import com.azure.resourcemanager.security.fluent.models.AutomationValidationStatusInner;
import com.azure.resourcemanager.security.implementation.AutomationImpl;
import com.azure.resourcemanager.security.implementation.AutomationValidationStatusImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.Automation;
import com.azure.resourcemanager.security.models.AutomationValidationStatus;
import com.azure.resourcemanager.security.models.Automations;

public final class AutomationsImpl
implements Automations {
    private static final ClientLogger LOGGER = new ClientLogger(AutomationsImpl.class);
    private final AutomationsClient innerClient;
    private final SecurityManager serviceManager;

    public AutomationsImpl(AutomationsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Automation> list() {
        PagedIterable<AutomationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutomationImpl((AutomationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Automation> list(Context context) {
        PagedIterable<AutomationInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutomationImpl((AutomationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Automation> listByResourceGroup(String resourceGroupName) {
        PagedIterable<AutomationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutomationImpl((AutomationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Automation> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<AutomationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutomationImpl((AutomationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Automation> getByResourceGroupWithResponse(String resourceGroupName, String automationName, Context context) {
        Response<AutomationInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, automationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AutomationImpl((AutomationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Automation getByResourceGroup(String resourceGroupName, String automationName) {
        AutomationInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, automationName);
        if (inner != null) {
            return new AutomationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String automationName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String automationName) {
        this.serviceClient().delete(resourceGroupName, automationName);
    }

    @Override
    public Response<AutomationValidationStatus> validateWithResponse(String resourceGroupName, String automationName, AutomationInner automation, Context context) {
        Response<AutomationValidationStatusInner> inner = this.serviceClient().validateWithResponse(resourceGroupName, automationName, automation, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AutomationValidationStatusImpl((AutomationValidationStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AutomationValidationStatus validate(String resourceGroupName, String automationName, AutomationInner automation) {
        AutomationValidationStatusInner inner = this.serviceClient().validate(resourceGroupName, automationName, automation);
        if (inner != null) {
            return new AutomationValidationStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Automation getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationName = ResourceManagerUtils.getValueFromIdByName(id, "automations");
        if (automationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automations'.", id)));
        }
        return (Automation)this.getByResourceGroupWithResponse(resourceGroupName, automationName, Context.NONE).getValue();
    }

    @Override
    public Response<Automation> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationName = ResourceManagerUtils.getValueFromIdByName(id, "automations");
        if (automationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automations'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, automationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationName = ResourceManagerUtils.getValueFromIdByName(id, "automations");
        if (automationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automations'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, automationName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationName = ResourceManagerUtils.getValueFromIdByName(id, "automations");
        if (automationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automations'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, automationName, context);
    }

    private AutomationsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutomationImpl define(String name) {
        return new AutomationImpl(name, this.manager());
    }
}

