/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.AzureDevOpsOrgsClient;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsOrgInner;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsOrgListResponseInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AzureDevOpsOrgsClientImpl
implements AzureDevOpsOrgsClient {
    private final AzureDevOpsOrgsService service;
    private final SecurityCenterImpl client;

    AzureDevOpsOrgsClientImpl(SecurityCenterImpl client) {
        this.service = (AzureDevOpsOrgsService)RestProxy.create(AzureDevOpsOrgsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureDevOpsOrgListResponseInner>> listAvailableWithResponseAsync(String resourceGroupName, String securityConnectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, "2023-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureDevOpsOrgListResponseInner>> listAvailableWithResponseAsync(String resourceGroupName, String securityConnectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAvailable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, "2023-09-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsOrgListResponseInner> listAvailableAsync(String resourceGroupName, String securityConnectorName) {
        return this.listAvailableWithResponseAsync(resourceGroupName, securityConnectorName).flatMap(res -> Mono.justOrEmpty((Object)((AzureDevOpsOrgListResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureDevOpsOrgListResponseInner> listAvailableWithResponse(String resourceGroupName, String securityConnectorName, Context context) {
        return (Response)this.listAvailableWithResponseAsync(resourceGroupName, securityConnectorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsOrgListResponseInner listAvailable(String resourceGroupName, String securityConnectorName) {
        return (AzureDevOpsOrgListResponseInner)this.listAvailableWithResponse(resourceGroupName, securityConnectorName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureDevOpsOrgInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, "2023-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureDevOpsOrgListResponseInner)res.getValue()).value(), ((AzureDevOpsOrgListResponseInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureDevOpsOrgInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, "2023-09-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureDevOpsOrgListResponseInner)res.getValue()).value(), ((AzureDevOpsOrgListResponseInner)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureDevOpsOrgInner> listAsync(String resourceGroupName, String securityConnectorName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureDevOpsOrgInner> listAsync(String resourceGroupName, String securityConnectorName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureDevOpsOrgInner> list(String resourceGroupName, String securityConnectorName) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureDevOpsOrgInner> list(String resourceGroupName, String securityConnectorName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureDevOpsOrgInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, "2023-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureDevOpsOrgInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, "2023-09-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsOrgInner> getAsync(String resourceGroupName, String securityConnectorName, String orgName) {
        return this.getWithResponseAsync(resourceGroupName, securityConnectorName, orgName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AzureDevOpsOrgInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureDevOpsOrgInner> getWithResponse(String resourceGroupName, String securityConnectorName, String orgName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, securityConnectorName, orgName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsOrgInner get(String resourceGroupName, String securityConnectorName, String orgName) {
        return (AzureDevOpsOrgInner)((Object)this.getWithResponse(resourceGroupName, securityConnectorName, orgName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (azureDevOpsOrg == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureDevOpsOrg is required and cannot be null."));
        }
        azureDevOpsOrg.validate();
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, "2023-09-01-preview", azureDevOpsOrg, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (azureDevOpsOrg == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureDevOpsOrg is required and cannot be null."));
        }
        azureDevOpsOrg.validate();
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, "2023-09-01-preview", azureDevOpsOrg, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AzureDevOpsOrgInner>, AzureDevOpsOrgInner> beginCreateOrUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AzureDevOpsOrgInner.class), (Type)((Object)AzureDevOpsOrgInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AzureDevOpsOrgInner>, AzureDevOpsOrgInner> beginCreateOrUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AzureDevOpsOrgInner.class), (Type)((Object)AzureDevOpsOrgInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureDevOpsOrgInner>, AzureDevOpsOrgInner> beginCreateOrUpdate(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureDevOpsOrgInner>, AzureDevOpsOrgInner> beginCreateOrUpdate(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsOrgInner> createOrUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsOrgInner> createOrUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsOrgInner createOrUpdate(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        return (AzureDevOpsOrgInner)((Object)this.createOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsOrgInner createOrUpdate(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        return (AzureDevOpsOrgInner)((Object)this.createOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (azureDevOpsOrg == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureDevOpsOrg is required and cannot be null."));
        }
        azureDevOpsOrg.validate();
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, "2023-09-01-preview", azureDevOpsOrg, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (azureDevOpsOrg == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureDevOpsOrg is required and cannot be null."));
        }
        azureDevOpsOrg.validate();
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, "2023-09-01-preview", azureDevOpsOrg, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AzureDevOpsOrgInner>, AzureDevOpsOrgInner> beginUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AzureDevOpsOrgInner.class), (Type)((Object)AzureDevOpsOrgInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AzureDevOpsOrgInner>, AzureDevOpsOrgInner> beginUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AzureDevOpsOrgInner.class), (Type)((Object)AzureDevOpsOrgInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureDevOpsOrgInner>, AzureDevOpsOrgInner> beginUpdate(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        return this.beginUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureDevOpsOrgInner>, AzureDevOpsOrgInner> beginUpdate(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        return this.beginUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsOrgInner> updateAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        return this.beginUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsOrgInner> updateAsync(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        return this.beginUpdateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsOrgInner update(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg) {
        return (AzureDevOpsOrgInner)((Object)this.updateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsOrgInner update(String resourceGroupName, String securityConnectorName, String orgName, AzureDevOpsOrgInner azureDevOpsOrg, Context context) {
        return (AzureDevOpsOrgInner)((Object)this.updateAsync(resourceGroupName, securityConnectorName, orgName, azureDevOpsOrg, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureDevOpsOrgInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureDevOpsOrgListResponseInner)res.getValue()).value(), ((AzureDevOpsOrgListResponseInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureDevOpsOrgInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureDevOpsOrgListResponseInner)res.getValue()).value(), ((AzureDevOpsOrgListResponseInner)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterAzureD")
    public static interface AzureDevOpsOrgsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/listAvailableAzureDevOpsOrgs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureDevOpsOrgListResponseInner>> listAvailable(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureDevOpsOrgListResponseInner>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureDevOpsOrgInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="orgName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="orgName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AzureDevOpsOrgInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="orgName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AzureDevOpsOrgInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureDevOpsOrgListResponseInner>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

