/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsProjectInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AzureDevOpsProject;
import com.azure.resourcemanager.security.models.AzureDevOpsProjectProperties;

public final class AzureDevOpsProjectImpl
implements AzureDevOpsProject,
AzureDevOpsProject.Definition,
AzureDevOpsProject.Update {
    private AzureDevOpsProjectInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceGroupName;
    private String securityConnectorName;
    private String orgName;
    private String projectName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AzureDevOpsProjectProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AzureDevOpsProjectInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AzureDevOpsProjectImpl withExistingAzureDevOpsOrg(String resourceGroupName, String securityConnectorName, String orgName) {
        this.resourceGroupName = resourceGroupName;
        this.securityConnectorName = securityConnectorName;
        this.orgName = orgName;
        return this;
    }

    @Override
    public AzureDevOpsProject create() {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsProjects().createOrUpdate(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AzureDevOpsProject create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsProjects().createOrUpdate(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.innerModel(), context);
        return this;
    }

    AzureDevOpsProjectImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new AzureDevOpsProjectInner();
        this.serviceManager = serviceManager;
        this.projectName = name;
    }

    @Override
    public AzureDevOpsProjectImpl update() {
        return this;
    }

    @Override
    public AzureDevOpsProject apply() {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsProjects().update(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AzureDevOpsProject apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsProjects().update(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.innerModel(), context);
        return this;
    }

    AzureDevOpsProjectImpl(AzureDevOpsProjectInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.securityConnectorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "securityConnectors");
        this.orgName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "azureDevOpsOrgs");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
    }

    @Override
    public AzureDevOpsProject refresh() {
        this.innerObject = (AzureDevOpsProjectInner)((Object)this.serviceManager.serviceClient().getAzureDevOpsProjects().getWithResponse(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AzureDevOpsProject refresh(Context context) {
        this.innerObject = (AzureDevOpsProjectInner)((Object)this.serviceManager.serviceClient().getAzureDevOpsProjects().getWithResponse(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, context).getValue());
        return this;
    }

    @Override
    public AzureDevOpsProjectImpl withProperties(AzureDevOpsProjectProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

