/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.AzureDevOpsReposClient;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsRepositoryInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.AzureDevOpsRepositoryListResponse;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AzureDevOpsReposClientImpl
implements AzureDevOpsReposClient {
    private final AzureDevOpsReposService service;
    private final SecurityCenterImpl client;

    AzureDevOpsReposClientImpl(SecurityCenterImpl client) {
        this.service = (AzureDevOpsReposService)RestProxy.create(AzureDevOpsReposService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureDevOpsRepositoryInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, projectName, "2023-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureDevOpsRepositoryListResponse)res.getValue()).value(), ((AzureDevOpsRepositoryListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureDevOpsRepositoryInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, projectName, "2023-09-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureDevOpsRepositoryListResponse)res.getValue()).value(), ((AzureDevOpsRepositoryListResponse)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureDevOpsRepositoryInner> listAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName, orgName, projectName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureDevOpsRepositoryInner> listAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName, orgName, projectName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureDevOpsRepositoryInner> list(String resourceGroupName, String securityConnectorName, String orgName, String projectName) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName, orgName, projectName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureDevOpsRepositoryInner> list(String resourceGroupName, String securityConnectorName, String orgName, String projectName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName, orgName, projectName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureDevOpsRepositoryInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (repoName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repoName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, projectName, repoName, "2023-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureDevOpsRepositoryInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (repoName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repoName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, projectName, repoName, "2023-09-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsRepositoryInner> getAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName) {
        return this.getWithResponseAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AzureDevOpsRepositoryInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureDevOpsRepositoryInner> getWithResponse(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsRepositoryInner get(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName) {
        return (AzureDevOpsRepositoryInner)((Object)this.getWithResponse(resourceGroupName, securityConnectorName, orgName, projectName, repoName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (repoName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repoName is required and cannot be null."));
        }
        if (azureDevOpsRepository == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureDevOpsRepository is required and cannot be null."));
        }
        azureDevOpsRepository.validate();
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, projectName, repoName, "2023-09-01-preview", azureDevOpsRepository, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (repoName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repoName is required and cannot be null."));
        }
        if (azureDevOpsRepository == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureDevOpsRepository is required and cannot be null."));
        }
        azureDevOpsRepository.validate();
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, projectName, repoName, "2023-09-01-preview", azureDevOpsRepository, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AzureDevOpsRepositoryInner>, AzureDevOpsRepositoryInner> beginCreateOrUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AzureDevOpsRepositoryInner.class), (Type)((Object)AzureDevOpsRepositoryInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AzureDevOpsRepositoryInner>, AzureDevOpsRepositoryInner> beginCreateOrUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AzureDevOpsRepositoryInner.class), (Type)((Object)AzureDevOpsRepositoryInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureDevOpsRepositoryInner>, AzureDevOpsRepositoryInner> beginCreateOrUpdate(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureDevOpsRepositoryInner>, AzureDevOpsRepositoryInner> beginCreateOrUpdate(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsRepositoryInner> createOrUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsRepositoryInner> createOrUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsRepositoryInner createOrUpdate(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        return (AzureDevOpsRepositoryInner)((Object)this.createOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsRepositoryInner createOrUpdate(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        return (AzureDevOpsRepositoryInner)((Object)this.createOrUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (repoName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repoName is required and cannot be null."));
        }
        if (azureDevOpsRepository == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureDevOpsRepository is required and cannot be null."));
        }
        azureDevOpsRepository.validate();
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, projectName, repoName, "2023-09-01-preview", azureDevOpsRepository, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (orgName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (repoName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repoName is required and cannot be null."));
        }
        if (azureDevOpsRepository == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureDevOpsRepository is required and cannot be null."));
        }
        azureDevOpsRepository.validate();
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, orgName, projectName, repoName, "2023-09-01-preview", azureDevOpsRepository, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AzureDevOpsRepositoryInner>, AzureDevOpsRepositoryInner> beginUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AzureDevOpsRepositoryInner.class), (Type)((Object)AzureDevOpsRepositoryInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AzureDevOpsRepositoryInner>, AzureDevOpsRepositoryInner> beginUpdateAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AzureDevOpsRepositoryInner.class), (Type)((Object)AzureDevOpsRepositoryInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureDevOpsRepositoryInner>, AzureDevOpsRepositoryInner> beginUpdate(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        return this.beginUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureDevOpsRepositoryInner>, AzureDevOpsRepositoryInner> beginUpdate(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        return this.beginUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsRepositoryInner> updateAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        return this.beginUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureDevOpsRepositoryInner> updateAsync(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        return this.beginUpdateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsRepositoryInner update(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository) {
        return (AzureDevOpsRepositoryInner)((Object)this.updateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureDevOpsRepositoryInner update(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, AzureDevOpsRepositoryInner azureDevOpsRepository, Context context) {
        return (AzureDevOpsRepositoryInner)((Object)this.updateAsync(resourceGroupName, securityConnectorName, orgName, projectName, repoName, azureDevOpsRepository, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureDevOpsRepositoryInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureDevOpsRepositoryListResponse)res.getValue()).value(), ((AzureDevOpsRepositoryListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureDevOpsRepositoryInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureDevOpsRepositoryListResponse)res.getValue()).value(), ((AzureDevOpsRepositoryListResponse)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterAzureD")
    public static interface AzureDevOpsReposService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}/projects/{projectName}/repos")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureDevOpsRepositoryListResponse>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="orgName") String var5, @PathParam(value="projectName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}/projects/{projectName}/repos/{repoName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureDevOpsRepositoryInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="orgName") String var5, @PathParam(value="projectName") String var6, @PathParam(value="repoName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}/projects/{projectName}/repos/{repoName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="orgName") String var5, @PathParam(value="projectName") String var6, @PathParam(value="repoName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") AzureDevOpsRepositoryInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}/projects/{projectName}/repos/{repoName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="orgName") String var5, @PathParam(value="projectName") String var6, @PathParam(value="repoName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") AzureDevOpsRepositoryInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureDevOpsRepositoryListResponse>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

