/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AzureDevOpsReposClient;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsRepositoryInner;
import com.azure.resourcemanager.security.implementation.AzureDevOpsRepositoryImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AzureDevOpsRepos;
import com.azure.resourcemanager.security.models.AzureDevOpsRepository;

public final class AzureDevOpsReposImpl
implements AzureDevOpsRepos {
    private static final ClientLogger LOGGER = new ClientLogger(AzureDevOpsReposImpl.class);
    private final AzureDevOpsReposClient innerClient;
    private final SecurityManager serviceManager;

    public AzureDevOpsReposImpl(AzureDevOpsReposClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AzureDevOpsRepository> list(String resourceGroupName, String securityConnectorName, String orgName, String projectName) {
        PagedIterable<AzureDevOpsRepositoryInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, orgName, projectName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureDevOpsRepositoryImpl((AzureDevOpsRepositoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AzureDevOpsRepository> list(String resourceGroupName, String securityConnectorName, String orgName, String projectName, Context context) {
        PagedIterable<AzureDevOpsRepositoryInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, orgName, projectName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureDevOpsRepositoryImpl((AzureDevOpsRepositoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AzureDevOpsRepository> getWithResponse(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName, Context context) {
        Response<AzureDevOpsRepositoryInner> inner = this.serviceClient().getWithResponse(resourceGroupName, securityConnectorName, orgName, projectName, repoName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AzureDevOpsRepositoryImpl((AzureDevOpsRepositoryInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AzureDevOpsRepository get(String resourceGroupName, String securityConnectorName, String orgName, String projectName, String repoName) {
        AzureDevOpsRepositoryInner inner = this.serviceClient().get(resourceGroupName, securityConnectorName, orgName, projectName, repoName);
        if (inner != null) {
            return new AzureDevOpsRepositoryImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AzureDevOpsRepository getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        String orgName = ResourceManagerUtils.getValueFromIdByName(id, "azureDevOpsOrgs");
        if (orgName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'azureDevOpsOrgs'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String repoName = ResourceManagerUtils.getValueFromIdByName(id, "repos");
        if (repoName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'repos'.", id)));
        }
        return (AzureDevOpsRepository)this.getWithResponse(resourceGroupName, securityConnectorName, orgName, projectName, repoName, Context.NONE).getValue();
    }

    @Override
    public Response<AzureDevOpsRepository> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        String orgName = ResourceManagerUtils.getValueFromIdByName(id, "azureDevOpsOrgs");
        if (orgName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'azureDevOpsOrgs'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String repoName = ResourceManagerUtils.getValueFromIdByName(id, "repos");
        if (repoName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'repos'.", id)));
        }
        return this.getWithResponse(resourceGroupName, securityConnectorName, orgName, projectName, repoName, context);
    }

    private AzureDevOpsReposClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AzureDevOpsRepositoryImpl define(String name) {
        return new AzureDevOpsRepositoryImpl(name, this.manager());
    }
}

