/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.ComplianceResultsClient;
import com.azure.resourcemanager.security.fluent.models.ComplianceResultInner;
import com.azure.resourcemanager.security.implementation.ComplianceResultImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.ComplianceResult;
import com.azure.resourcemanager.security.models.ComplianceResults;

public final class ComplianceResultsImpl
implements ComplianceResults {
    private static final ClientLogger LOGGER = new ClientLogger(ComplianceResultsImpl.class);
    private final ComplianceResultsClient innerClient;
    private final SecurityManager serviceManager;

    public ComplianceResultsImpl(ComplianceResultsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ComplianceResult> list(String scope) {
        PagedIterable<ComplianceResultInner> inner = this.serviceClient().list(scope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ComplianceResultImpl((ComplianceResultInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ComplianceResult> list(String scope, Context context) {
        PagedIterable<ComplianceResultInner> inner = this.serviceClient().list(scope, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ComplianceResultImpl((ComplianceResultInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ComplianceResult> getWithResponse(String resourceId, String complianceResultName, Context context) {
        Response<ComplianceResultInner> inner = this.serviceClient().getWithResponse(resourceId, complianceResultName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComplianceResultImpl((ComplianceResultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ComplianceResult get(String resourceId, String complianceResultName) {
        ComplianceResultInner inner = this.serviceClient().get(resourceId, complianceResultName);
        if (inner != null) {
            return new ComplianceResultImpl(inner, this.manager());
        }
        return null;
    }

    private ComplianceResultsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

