/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.CompliancesClient;
import com.azure.resourcemanager.security.fluent.models.ComplianceInner;
import com.azure.resourcemanager.security.implementation.ComplianceImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.Compliance;
import com.azure.resourcemanager.security.models.Compliances;

public final class CompliancesImpl
implements Compliances {
    private static final ClientLogger LOGGER = new ClientLogger(CompliancesImpl.class);
    private final CompliancesClient innerClient;
    private final SecurityManager serviceManager;

    public CompliancesImpl(CompliancesClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Compliance> list(String scope) {
        PagedIterable<ComplianceInner> inner = this.serviceClient().list(scope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ComplianceImpl((ComplianceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Compliance> list(String scope, Context context) {
        PagedIterable<ComplianceInner> inner = this.serviceClient().list(scope, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ComplianceImpl((ComplianceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Compliance> getWithResponse(String scope, String complianceName, Context context) {
        Response<ComplianceInner> inner = this.serviceClient().getWithResponse(scope, complianceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComplianceImpl((ComplianceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Compliance get(String scope, String complianceName) {
        ComplianceInner inner = this.serviceClient().get(scope, complianceName);
        if (inner != null) {
            return new ComplianceImpl(inner, this.manager());
        }
        return null;
    }

    private CompliancesClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

