/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.ConnectorSettingInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AuthenticationDetailsProperties;
import com.azure.resourcemanager.security.models.ConnectorSetting;
import com.azure.resourcemanager.security.models.HybridComputeSettingsProperties;

public final class ConnectorSettingImpl
implements ConnectorSetting,
ConnectorSetting.Definition,
ConnectorSetting.Update {
    private ConnectorSettingInner innerObject;
    private final SecurityManager serviceManager;
    private String connectorName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public HybridComputeSettingsProperties hybridComputeSettings() {
        return this.innerModel().hybridComputeSettings();
    }

    @Override
    public AuthenticationDetailsProperties authenticationDetails() {
        return this.innerModel().authenticationDetails();
    }

    @Override
    public ConnectorSettingInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectorSetting create() {
        this.innerObject = (ConnectorSettingInner)((Object)this.serviceManager.serviceClient().getConnectors().createOrUpdateWithResponse(this.connectorName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectorSetting create(Context context) {
        this.innerObject = (ConnectorSettingInner)((Object)this.serviceManager.serviceClient().getConnectors().createOrUpdateWithResponse(this.connectorName, this.innerModel(), context).getValue());
        return this;
    }

    ConnectorSettingImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new ConnectorSettingInner();
        this.serviceManager = serviceManager;
        this.connectorName = name;
    }

    @Override
    public ConnectorSettingImpl update() {
        return this;
    }

    @Override
    public ConnectorSetting apply() {
        this.innerObject = (ConnectorSettingInner)((Object)this.serviceManager.serviceClient().getConnectors().createOrUpdateWithResponse(this.connectorName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectorSetting apply(Context context) {
        this.innerObject = (ConnectorSettingInner)((Object)this.serviceManager.serviceClient().getConnectors().createOrUpdateWithResponse(this.connectorName, this.innerModel(), context).getValue());
        return this;
    }

    ConnectorSettingImpl(ConnectorSettingInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.connectorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "connectors");
    }

    @Override
    public ConnectorSetting refresh() {
        this.innerObject = (ConnectorSettingInner)((Object)this.serviceManager.serviceClient().getConnectors().getWithResponse(this.connectorName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectorSetting refresh(Context context) {
        this.innerObject = (ConnectorSettingInner)((Object)this.serviceManager.serviceClient().getConnectors().getWithResponse(this.connectorName, context).getValue());
        return this;
    }

    @Override
    public ConnectorSettingImpl withHybridComputeSettings(HybridComputeSettingsProperties hybridComputeSettings) {
        this.innerModel().withHybridComputeSettings(hybridComputeSettings);
        return this;
    }

    @Override
    public ConnectorSettingImpl withAuthenticationDetails(AuthenticationDetailsProperties authenticationDetails) {
        this.innerModel().withAuthenticationDetails(authenticationDetails);
        return this;
    }
}

