/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.CustomEntityStoreAssignmentsClient;
import com.azure.resourcemanager.security.fluent.models.CustomEntityStoreAssignmentInner;
import com.azure.resourcemanager.security.implementation.CustomEntityStoreAssignmentImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.CustomEntityStoreAssignment;
import com.azure.resourcemanager.security.models.CustomEntityStoreAssignments;

public final class CustomEntityStoreAssignmentsImpl
implements CustomEntityStoreAssignments {
    private static final ClientLogger LOGGER = new ClientLogger(CustomEntityStoreAssignmentsImpl.class);
    private final CustomEntityStoreAssignmentsClient innerClient;
    private final SecurityManager serviceManager;

    public CustomEntityStoreAssignmentsImpl(CustomEntityStoreAssignmentsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CustomEntityStoreAssignment> getByResourceGroupWithResponse(String resourceGroupName, String customEntityStoreAssignmentName, Context context) {
        Response<CustomEntityStoreAssignmentInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, customEntityStoreAssignmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CustomEntityStoreAssignmentImpl((CustomEntityStoreAssignmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public CustomEntityStoreAssignment getByResourceGroup(String resourceGroupName, String customEntityStoreAssignmentName) {
        CustomEntityStoreAssignmentInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, customEntityStoreAssignmentName);
        if (inner != null) {
            return new CustomEntityStoreAssignmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String customEntityStoreAssignmentName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, customEntityStoreAssignmentName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String customEntityStoreAssignmentName) {
        this.serviceClient().delete(resourceGroupName, customEntityStoreAssignmentName);
    }

    @Override
    public PagedIterable<CustomEntityStoreAssignment> listByResourceGroup(String resourceGroupName) {
        PagedIterable<CustomEntityStoreAssignmentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomEntityStoreAssignmentImpl((CustomEntityStoreAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CustomEntityStoreAssignment> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<CustomEntityStoreAssignmentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomEntityStoreAssignmentImpl((CustomEntityStoreAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CustomEntityStoreAssignment> list() {
        PagedIterable<CustomEntityStoreAssignmentInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomEntityStoreAssignmentImpl((CustomEntityStoreAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CustomEntityStoreAssignment> list(Context context) {
        PagedIterable<CustomEntityStoreAssignmentInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomEntityStoreAssignmentImpl((CustomEntityStoreAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public CustomEntityStoreAssignment getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String customEntityStoreAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "customEntityStoreAssignments");
        if (customEntityStoreAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customEntityStoreAssignments'.", id)));
        }
        return (CustomEntityStoreAssignment)this.getByResourceGroupWithResponse(resourceGroupName, customEntityStoreAssignmentName, Context.NONE).getValue();
    }

    @Override
    public Response<CustomEntityStoreAssignment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String customEntityStoreAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "customEntityStoreAssignments");
        if (customEntityStoreAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customEntityStoreAssignments'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, customEntityStoreAssignmentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String customEntityStoreAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "customEntityStoreAssignments");
        if (customEntityStoreAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customEntityStoreAssignments'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, customEntityStoreAssignmentName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String customEntityStoreAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "customEntityStoreAssignments");
        if (customEntityStoreAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customEntityStoreAssignments'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, customEntityStoreAssignmentName, context);
    }

    private CustomEntityStoreAssignmentsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public CustomEntityStoreAssignmentImpl define(String name) {
        return new CustomEntityStoreAssignmentImpl(name, this.manager());
    }
}

