/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.DefenderForStorageSettingInner;
import com.azure.resourcemanager.security.models.DefenderForStorageSetting;
import com.azure.resourcemanager.security.models.OperationStatus;
import com.azure.resourcemanager.security.models.SettingName;

public final class DefenderForStorageSettingImpl
implements DefenderForStorageSetting,
DefenderForStorageSetting.Definition {
    private DefenderForStorageSettingInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceId;
    private SettingName settingName;

    DefenderForStorageSettingImpl(DefenderForStorageSettingInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Boolean isEnabled() {
        return this.innerModel().isEnabled();
    }

    @Override
    public Boolean overrideSubscriptionLevelSettings() {
        return this.innerModel().overrideSubscriptionLevelSettings();
    }

    @Override
    public String scanResultsEventGridTopicResourceId() {
        return this.innerModel().scanResultsEventGridTopicResourceId();
    }

    @Override
    public OperationStatus operationStatus() {
        return this.innerModel().operationStatus();
    }

    @Override
    public Boolean isEnabledMalwareScanningIsEnabled() {
        return this.innerModel().isEnabledMalwareScanningIsEnabled();
    }

    @Override
    public Integer capGBPerMonth() {
        return this.innerModel().capGBPerMonth();
    }

    @Override
    public Boolean isEnabledSensitiveDataDiscoveryIsEnabled() {
        return this.innerModel().isEnabledSensitiveDataDiscoveryIsEnabled();
    }

    @Override
    public OperationStatus operationStatusSensitiveDataDiscoveryOperationStatus() {
        return this.innerModel().operationStatusSensitiveDataDiscoveryOperationStatus();
    }

    @Override
    public DefenderForStorageSettingInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public DefenderForStorageSettingImpl withExistingResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Override
    public DefenderForStorageSetting create() {
        this.innerObject = (DefenderForStorageSettingInner)((Object)this.serviceManager.serviceClient().getDefenderForStorages().createWithResponse(this.resourceId, this.settingName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DefenderForStorageSetting create(Context context) {
        this.innerObject = (DefenderForStorageSettingInner)((Object)this.serviceManager.serviceClient().getDefenderForStorages().createWithResponse(this.resourceId, this.settingName, this.innerModel(), context).getValue());
        return this;
    }

    DefenderForStorageSettingImpl(SettingName name, SecurityManager serviceManager) {
        this.innerObject = new DefenderForStorageSettingInner();
        this.serviceManager = serviceManager;
        this.settingName = name;
    }

    @Override
    public DefenderForStorageSetting refresh() {
        this.innerObject = (DefenderForStorageSettingInner)((Object)this.serviceManager.serviceClient().getDefenderForStorages().getWithResponse(this.resourceId, this.settingName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DefenderForStorageSetting refresh(Context context) {
        this.innerObject = (DefenderForStorageSettingInner)((Object)this.serviceManager.serviceClient().getDefenderForStorages().getWithResponse(this.resourceId, this.settingName, context).getValue());
        return this;
    }

    @Override
    public DefenderForStorageSettingImpl withIsEnabled(Boolean isEnabled) {
        this.innerModel().withIsEnabled(isEnabled);
        return this;
    }

    @Override
    public DefenderForStorageSettingImpl withOverrideSubscriptionLevelSettings(Boolean overrideSubscriptionLevelSettings) {
        this.innerModel().withOverrideSubscriptionLevelSettings(overrideSubscriptionLevelSettings);
        return this;
    }

    @Override
    public DefenderForStorageSettingImpl withScanResultsEventGridTopicResourceId(String scanResultsEventGridTopicResourceId) {
        this.innerModel().withScanResultsEventGridTopicResourceId(scanResultsEventGridTopicResourceId);
        return this;
    }

    @Override
    public DefenderForStorageSettingImpl withIsEnabledMalwareScanningIsEnabled(Boolean isEnabledMalwareScanningIsEnabled) {
        this.innerModel().withIsEnabledMalwareScanningIsEnabled(isEnabledMalwareScanningIsEnabled);
        return this;
    }

    @Override
    public DefenderForStorageSettingImpl withCapGBPerMonth(Integer capGBPerMonth) {
        this.innerModel().withCapGBPerMonth(capGBPerMonth);
        return this;
    }

    @Override
    public DefenderForStorageSettingImpl withIsEnabledSensitiveDataDiscoveryIsEnabled(Boolean isEnabledSensitiveDataDiscoveryIsEnabled) {
        this.innerModel().withIsEnabledSensitiveDataDiscoveryIsEnabled(isEnabledSensitiveDataDiscoveryIsEnabled);
        return this;
    }
}

