/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.DevOpsOperationResultsClient;
import com.azure.resourcemanager.security.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.security.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.security.models.DevOpsOperationResults;
import com.azure.resourcemanager.security.models.OperationStatusResult;

public final class DevOpsOperationResultsImpl
implements DevOpsOperationResults {
    private static final ClientLogger LOGGER = new ClientLogger(DevOpsOperationResultsImpl.class);
    private final DevOpsOperationResultsClient innerClient;
    private final SecurityManager serviceManager;

    public DevOpsOperationResultsImpl(DevOpsOperationResultsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationStatusResult> getWithResponse(String resourceGroupName, String securityConnectorName, String operationResultId, Context context) {
        Response<OperationStatusResultInner> inner = this.serviceClient().getWithResponse(resourceGroupName, securityConnectorName, operationResultId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationStatusResultImpl((OperationStatusResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationStatusResult get(String resourceGroupName, String securityConnectorName, String operationResultId) {
        OperationStatusResultInner inner = this.serviceClient().get(resourceGroupName, securityConnectorName, operationResultId);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    private DevOpsOperationResultsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

