/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.DeviceSecurityGroupInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AllowlistCustomAlertRule;
import com.azure.resourcemanager.security.models.DenylistCustomAlertRule;
import com.azure.resourcemanager.security.models.DeviceSecurityGroup;
import com.azure.resourcemanager.security.models.ThresholdCustomAlertRule;
import com.azure.resourcemanager.security.models.TimeWindowCustomAlertRule;
import java.util.Collections;
import java.util.List;

public final class DeviceSecurityGroupImpl
implements DeviceSecurityGroup,
DeviceSecurityGroup.Definition,
DeviceSecurityGroup.Update {
    private DeviceSecurityGroupInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceId;
    private String deviceSecurityGroupName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public List<ThresholdCustomAlertRule> thresholdRules() {
        List<ThresholdCustomAlertRule> inner = this.innerModel().thresholdRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<TimeWindowCustomAlertRule> timeWindowRules() {
        List<TimeWindowCustomAlertRule> inner = this.innerModel().timeWindowRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<AllowlistCustomAlertRule> allowlistRules() {
        List<AllowlistCustomAlertRule> inner = this.innerModel().allowlistRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DenylistCustomAlertRule> denylistRules() {
        List<DenylistCustomAlertRule> inner = this.innerModel().denylistRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public DeviceSecurityGroupInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public DeviceSecurityGroupImpl withExistingResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Override
    public DeviceSecurityGroup create() {
        this.innerObject = (DeviceSecurityGroupInner)((Object)this.serviceManager.serviceClient().getDeviceSecurityGroups().createOrUpdateWithResponse(this.resourceId, this.deviceSecurityGroupName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DeviceSecurityGroup create(Context context) {
        this.innerObject = (DeviceSecurityGroupInner)((Object)this.serviceManager.serviceClient().getDeviceSecurityGroups().createOrUpdateWithResponse(this.resourceId, this.deviceSecurityGroupName, this.innerModel(), context).getValue());
        return this;
    }

    DeviceSecurityGroupImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new DeviceSecurityGroupInner();
        this.serviceManager = serviceManager;
        this.deviceSecurityGroupName = name;
    }

    @Override
    public DeviceSecurityGroupImpl update() {
        return this;
    }

    @Override
    public DeviceSecurityGroup apply() {
        this.innerObject = (DeviceSecurityGroupInner)((Object)this.serviceManager.serviceClient().getDeviceSecurityGroups().createOrUpdateWithResponse(this.resourceId, this.deviceSecurityGroupName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DeviceSecurityGroup apply(Context context) {
        this.innerObject = (DeviceSecurityGroupInner)((Object)this.serviceManager.serviceClient().getDeviceSecurityGroups().createOrUpdateWithResponse(this.resourceId, this.deviceSecurityGroupName, this.innerModel(), context).getValue());
        return this;
    }

    DeviceSecurityGroupImpl(DeviceSecurityGroupInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceId = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "resourceId");
        this.deviceSecurityGroupName = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "deviceSecurityGroupName");
    }

    @Override
    public DeviceSecurityGroup refresh() {
        this.innerObject = (DeviceSecurityGroupInner)((Object)this.serviceManager.serviceClient().getDeviceSecurityGroups().getWithResponse(this.resourceId, this.deviceSecurityGroupName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DeviceSecurityGroup refresh(Context context) {
        this.innerObject = (DeviceSecurityGroupInner)((Object)this.serviceManager.serviceClient().getDeviceSecurityGroups().getWithResponse(this.resourceId, this.deviceSecurityGroupName, context).getValue());
        return this;
    }

    @Override
    public DeviceSecurityGroupImpl withThresholdRules(List<ThresholdCustomAlertRule> thresholdRules) {
        this.innerModel().withThresholdRules(thresholdRules);
        return this;
    }

    @Override
    public DeviceSecurityGroupImpl withTimeWindowRules(List<TimeWindowCustomAlertRule> timeWindowRules) {
        this.innerModel().withTimeWindowRules(timeWindowRules);
        return this;
    }

    @Override
    public DeviceSecurityGroupImpl withAllowlistRules(List<AllowlistCustomAlertRule> allowlistRules) {
        this.innerModel().withAllowlistRules(allowlistRules);
        return this;
    }

    @Override
    public DeviceSecurityGroupImpl withDenylistRules(List<DenylistCustomAlertRule> denylistRules) {
        this.innerModel().withDenylistRules(denylistRules);
        return this;
    }
}

