/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.DeviceSecurityGroupsClient;
import com.azure.resourcemanager.security.fluent.models.DeviceSecurityGroupInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.DeviceSecurityGroupList;
import reactor.core.publisher.Mono;

public final class DeviceSecurityGroupsClientImpl
implements DeviceSecurityGroupsClient {
    private final DeviceSecurityGroupsService service;
    private final SecurityCenterImpl client;

    DeviceSecurityGroupsClientImpl(SecurityCenterImpl client) {
        this.service = (DeviceSecurityGroupsService)RestProxy.create(DeviceSecurityGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeviceSecurityGroupInner>> listSinglePageAsync(String resourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-08-01", resourceId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeviceSecurityGroupList)res.getValue()).value(), ((DeviceSecurityGroupList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeviceSecurityGroupInner>> listSinglePageAsync(String resourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-08-01", resourceId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeviceSecurityGroupList)res.getValue()).value(), ((DeviceSecurityGroupList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeviceSecurityGroupInner> listAsync(String resourceId) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceId), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeviceSecurityGroupInner> listAsync(String resourceId, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceId, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeviceSecurityGroupInner> list(String resourceId) {
        return new PagedIterable(this.listAsync(resourceId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeviceSecurityGroupInner> list(String resourceId, Context context) {
        return new PagedIterable(this.listAsync(resourceId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeviceSecurityGroupInner>> getWithResponseAsync(String resourceId, String deviceSecurityGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (deviceSecurityGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceSecurityGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2019-08-01", resourceId, deviceSecurityGroupName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeviceSecurityGroupInner>> getWithResponseAsync(String resourceId, String deviceSecurityGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (deviceSecurityGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceSecurityGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2019-08-01", resourceId, deviceSecurityGroupName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeviceSecurityGroupInner> getAsync(String resourceId, String deviceSecurityGroupName) {
        return this.getWithResponseAsync(resourceId, deviceSecurityGroupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DeviceSecurityGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeviceSecurityGroupInner> getWithResponse(String resourceId, String deviceSecurityGroupName, Context context) {
        return (Response)this.getWithResponseAsync(resourceId, deviceSecurityGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeviceSecurityGroupInner get(String resourceId, String deviceSecurityGroupName) {
        return (DeviceSecurityGroupInner)((Object)this.getWithResponse(resourceId, deviceSecurityGroupName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeviceSecurityGroupInner>> createOrUpdateWithResponseAsync(String resourceId, String deviceSecurityGroupName, DeviceSecurityGroupInner deviceSecurityGroup) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (deviceSecurityGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceSecurityGroupName is required and cannot be null."));
        }
        if (deviceSecurityGroup == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceSecurityGroup is required and cannot be null."));
        }
        deviceSecurityGroup.validate();
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2019-08-01", resourceId, deviceSecurityGroupName, deviceSecurityGroup, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeviceSecurityGroupInner>> createOrUpdateWithResponseAsync(String resourceId, String deviceSecurityGroupName, DeviceSecurityGroupInner deviceSecurityGroup, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (deviceSecurityGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceSecurityGroupName is required and cannot be null."));
        }
        if (deviceSecurityGroup == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceSecurityGroup is required and cannot be null."));
        }
        deviceSecurityGroup.validate();
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2019-08-01", resourceId, deviceSecurityGroupName, deviceSecurityGroup, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeviceSecurityGroupInner> createOrUpdateAsync(String resourceId, String deviceSecurityGroupName, DeviceSecurityGroupInner deviceSecurityGroup) {
        return this.createOrUpdateWithResponseAsync(resourceId, deviceSecurityGroupName, deviceSecurityGroup).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DeviceSecurityGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeviceSecurityGroupInner> createOrUpdateWithResponse(String resourceId, String deviceSecurityGroupName, DeviceSecurityGroupInner deviceSecurityGroup, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceId, deviceSecurityGroupName, deviceSecurityGroup, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeviceSecurityGroupInner createOrUpdate(String resourceId, String deviceSecurityGroupName, DeviceSecurityGroupInner deviceSecurityGroup) {
        return (DeviceSecurityGroupInner)((Object)this.createOrUpdateWithResponse(resourceId, deviceSecurityGroupName, deviceSecurityGroup, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceId, String deviceSecurityGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (deviceSecurityGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceSecurityGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2019-08-01", resourceId, deviceSecurityGroupName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceId, String deviceSecurityGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (deviceSecurityGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceSecurityGroupName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2019-08-01", resourceId, deviceSecurityGroupName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceId, String deviceSecurityGroupName) {
        return this.deleteWithResponseAsync(resourceId, deviceSecurityGroupName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceId, String deviceSecurityGroupName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceId, deviceSecurityGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceId, String deviceSecurityGroupName) {
        this.deleteWithResponse(resourceId, deviceSecurityGroupName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeviceSecurityGroupInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeviceSecurityGroupList)res.getValue()).value(), ((DeviceSecurityGroupList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeviceSecurityGroupInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeviceSecurityGroupList)res.getValue()).value(), ((DeviceSecurityGroupList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterDevice")
    public static interface DeviceSecurityGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeviceSecurityGroupList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeviceSecurityGroupInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @PathParam(value="deviceSecurityGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeviceSecurityGroupInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @PathParam(value="deviceSecurityGroupName") String var4, @BodyParam(value="application/json") DeviceSecurityGroupInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @PathParam(value="deviceSecurityGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeviceSecurityGroupList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

