/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.DiscoveredSecuritySolutionsClient;
import com.azure.resourcemanager.security.fluent.models.DiscoveredSecuritySolutionInner;
import com.azure.resourcemanager.security.implementation.DiscoveredSecuritySolutionImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.DiscoveredSecuritySolution;
import com.azure.resourcemanager.security.models.DiscoveredSecuritySolutions;

public final class DiscoveredSecuritySolutionsImpl
implements DiscoveredSecuritySolutions {
    private static final ClientLogger LOGGER = new ClientLogger(DiscoveredSecuritySolutionsImpl.class);
    private final DiscoveredSecuritySolutionsClient innerClient;
    private final SecurityManager serviceManager;

    public DiscoveredSecuritySolutionsImpl(DiscoveredSecuritySolutionsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DiscoveredSecuritySolution> list() {
        PagedIterable<DiscoveredSecuritySolutionInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiscoveredSecuritySolutionImpl((DiscoveredSecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DiscoveredSecuritySolution> list(Context context) {
        PagedIterable<DiscoveredSecuritySolutionInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiscoveredSecuritySolutionImpl((DiscoveredSecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DiscoveredSecuritySolution> listByHomeRegion(String ascLocation) {
        PagedIterable<DiscoveredSecuritySolutionInner> inner = this.serviceClient().listByHomeRegion(ascLocation);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiscoveredSecuritySolutionImpl((DiscoveredSecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DiscoveredSecuritySolution> listByHomeRegion(String ascLocation, Context context) {
        PagedIterable<DiscoveredSecuritySolutionInner> inner = this.serviceClient().listByHomeRegion(ascLocation, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiscoveredSecuritySolutionImpl((DiscoveredSecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DiscoveredSecuritySolution> getWithResponse(String resourceGroupName, String ascLocation, String discoveredSecuritySolutionName, Context context) {
        Response<DiscoveredSecuritySolutionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, ascLocation, discoveredSecuritySolutionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiscoveredSecuritySolutionImpl((DiscoveredSecuritySolutionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DiscoveredSecuritySolution get(String resourceGroupName, String ascLocation, String discoveredSecuritySolutionName) {
        DiscoveredSecuritySolutionInner inner = this.serviceClient().get(resourceGroupName, ascLocation, discoveredSecuritySolutionName);
        if (inner != null) {
            return new DiscoveredSecuritySolutionImpl(inner, this.manager());
        }
        return null;
    }

    private DiscoveredSecuritySolutionsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

