/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.GitHubReposClient;
import com.azure.resourcemanager.security.fluent.models.GitHubRepositoryInner;
import com.azure.resourcemanager.security.implementation.GitHubRepositoryImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.GitHubRepos;
import com.azure.resourcemanager.security.models.GitHubRepository;

public final class GitHubReposImpl
implements GitHubRepos {
    private static final ClientLogger LOGGER = new ClientLogger(GitHubReposImpl.class);
    private final GitHubReposClient innerClient;
    private final SecurityManager serviceManager;

    public GitHubReposImpl(GitHubReposClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GitHubRepository> list(String resourceGroupName, String securityConnectorName, String ownerName) {
        PagedIterable<GitHubRepositoryInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, ownerName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GitHubRepositoryImpl((GitHubRepositoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GitHubRepository> list(String resourceGroupName, String securityConnectorName, String ownerName, Context context) {
        PagedIterable<GitHubRepositoryInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, ownerName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GitHubRepositoryImpl((GitHubRepositoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<GitHubRepository> getWithResponse(String resourceGroupName, String securityConnectorName, String ownerName, String repoName, Context context) {
        Response<GitHubRepositoryInner> inner = this.serviceClient().getWithResponse(resourceGroupName, securityConnectorName, ownerName, repoName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GitHubRepositoryImpl((GitHubRepositoryInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GitHubRepository get(String resourceGroupName, String securityConnectorName, String ownerName, String repoName) {
        GitHubRepositoryInner inner = this.serviceClient().get(resourceGroupName, securityConnectorName, ownerName, repoName);
        if (inner != null) {
            return new GitHubRepositoryImpl(inner, this.manager());
        }
        return null;
    }

    private GitHubReposClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

