/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.GovernanceAssignmentInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.GovernanceAssignment;
import com.azure.resourcemanager.security.models.GovernanceAssignmentAdditionalData;
import com.azure.resourcemanager.security.models.GovernanceEmailNotification;
import com.azure.resourcemanager.security.models.RemediationEta;
import java.time.OffsetDateTime;

public final class GovernanceAssignmentImpl
implements GovernanceAssignment,
GovernanceAssignment.Definition,
GovernanceAssignment.Update {
    private GovernanceAssignmentInner innerObject;
    private final SecurityManager serviceManager;
    private String scope;
    private String assessmentName;
    private String assignmentKey;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String owner() {
        return this.innerModel().owner();
    }

    @Override
    public OffsetDateTime remediationDueDate() {
        return this.innerModel().remediationDueDate();
    }

    @Override
    public RemediationEta remediationEta() {
        return this.innerModel().remediationEta();
    }

    @Override
    public Boolean isGracePeriod() {
        return this.innerModel().isGracePeriod();
    }

    @Override
    public GovernanceEmailNotification governanceEmailNotification() {
        return this.innerModel().governanceEmailNotification();
    }

    @Override
    public GovernanceAssignmentAdditionalData additionalData() {
        return this.innerModel().additionalData();
    }

    @Override
    public GovernanceAssignmentInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public GovernanceAssignmentImpl withExistingAssessment(String scope, String assessmentName) {
        this.scope = scope;
        this.assessmentName = assessmentName;
        return this;
    }

    @Override
    public GovernanceAssignment create() {
        this.innerObject = (GovernanceAssignmentInner)((Object)this.serviceManager.serviceClient().getGovernanceAssignments().createOrUpdateWithResponse(this.scope, this.assessmentName, this.assignmentKey, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public GovernanceAssignment create(Context context) {
        this.innerObject = (GovernanceAssignmentInner)((Object)this.serviceManager.serviceClient().getGovernanceAssignments().createOrUpdateWithResponse(this.scope, this.assessmentName, this.assignmentKey, this.innerModel(), context).getValue());
        return this;
    }

    GovernanceAssignmentImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new GovernanceAssignmentInner();
        this.serviceManager = serviceManager;
        this.assignmentKey = name;
    }

    @Override
    public GovernanceAssignmentImpl update() {
        return this;
    }

    @Override
    public GovernanceAssignment apply() {
        this.innerObject = (GovernanceAssignmentInner)((Object)this.serviceManager.serviceClient().getGovernanceAssignments().createOrUpdateWithResponse(this.scope, this.assessmentName, this.assignmentKey, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public GovernanceAssignment apply(Context context) {
        this.innerObject = (GovernanceAssignmentInner)((Object)this.serviceManager.serviceClient().getGovernanceAssignments().createOrUpdateWithResponse(this.scope, this.assessmentName, this.assignmentKey, this.innerModel(), context).getValue());
        return this;
    }

    GovernanceAssignmentImpl(GovernanceAssignmentInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.scope = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "scope");
        this.assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assessmentName");
        this.assignmentKey = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assignmentKey");
    }

    @Override
    public GovernanceAssignment refresh() {
        this.innerObject = (GovernanceAssignmentInner)((Object)this.serviceManager.serviceClient().getGovernanceAssignments().getWithResponse(this.scope, this.assessmentName, this.assignmentKey, Context.NONE).getValue());
        return this;
    }

    @Override
    public GovernanceAssignment refresh(Context context) {
        this.innerObject = (GovernanceAssignmentInner)((Object)this.serviceManager.serviceClient().getGovernanceAssignments().getWithResponse(this.scope, this.assessmentName, this.assignmentKey, context).getValue());
        return this;
    }

    @Override
    public GovernanceAssignmentImpl withOwner(String owner) {
        this.innerModel().withOwner(owner);
        return this;
    }

    @Override
    public GovernanceAssignmentImpl withRemediationDueDate(OffsetDateTime remediationDueDate) {
        this.innerModel().withRemediationDueDate(remediationDueDate);
        return this;
    }

    @Override
    public GovernanceAssignmentImpl withRemediationEta(RemediationEta remediationEta) {
        this.innerModel().withRemediationEta(remediationEta);
        return this;
    }

    @Override
    public GovernanceAssignmentImpl withIsGracePeriod(Boolean isGracePeriod) {
        this.innerModel().withIsGracePeriod(isGracePeriod);
        return this;
    }

    @Override
    public GovernanceAssignmentImpl withGovernanceEmailNotification(GovernanceEmailNotification governanceEmailNotification) {
        this.innerModel().withGovernanceEmailNotification(governanceEmailNotification);
        return this;
    }

    @Override
    public GovernanceAssignmentImpl withAdditionalData(GovernanceAssignmentAdditionalData additionalData) {
        this.innerModel().withAdditionalData(additionalData);
        return this;
    }
}

