/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.GovernanceRuleInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.ExecuteGovernanceRuleParams;
import com.azure.resourcemanager.security.models.GovernanceRule;
import com.azure.resourcemanager.security.models.GovernanceRuleEmailNotification;
import com.azure.resourcemanager.security.models.GovernanceRuleMetadata;
import com.azure.resourcemanager.security.models.GovernanceRuleOwnerSource;
import com.azure.resourcemanager.security.models.GovernanceRuleSourceResourceType;
import com.azure.resourcemanager.security.models.GovernanceRuleType;
import java.util.Collections;
import java.util.List;

public final class GovernanceRuleImpl
implements GovernanceRule,
GovernanceRule.Definition,
GovernanceRule.Update {
    private GovernanceRuleInner innerObject;
    private final SecurityManager serviceManager;
    private String scope;
    private String ruleId;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String tenantId() {
        return this.innerModel().tenantId();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String remediationTimeframe() {
        return this.innerModel().remediationTimeframe();
    }

    @Override
    public Boolean isGracePeriod() {
        return this.innerModel().isGracePeriod();
    }

    @Override
    public int rulePriority() {
        return this.innerModel().rulePriority();
    }

    @Override
    public Boolean isDisabled() {
        return this.innerModel().isDisabled();
    }

    @Override
    public GovernanceRuleType ruleType() {
        return this.innerModel().ruleType();
    }

    @Override
    public GovernanceRuleSourceResourceType sourceResourceType() {
        return this.innerModel().sourceResourceType();
    }

    @Override
    public List<String> excludedScopes() {
        List<String> inner = this.innerModel().excludedScopes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Object> conditionSets() {
        List<Object> inner = this.innerModel().conditionSets();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean includeMemberScopes() {
        return this.innerModel().includeMemberScopes();
    }

    @Override
    public GovernanceRuleOwnerSource ownerSource() {
        return this.innerModel().ownerSource();
    }

    @Override
    public GovernanceRuleEmailNotification governanceEmailNotification() {
        return this.innerModel().governanceEmailNotification();
    }

    @Override
    public GovernanceRuleMetadata metadata() {
        return this.innerModel().metadata();
    }

    @Override
    public GovernanceRuleInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public GovernanceRuleImpl withExistingScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public GovernanceRule create() {
        this.innerObject = (GovernanceRuleInner)((Object)this.serviceManager.serviceClient().getGovernanceRules().createOrUpdateWithResponse(this.scope, this.ruleId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public GovernanceRule create(Context context) {
        this.innerObject = (GovernanceRuleInner)((Object)this.serviceManager.serviceClient().getGovernanceRules().createOrUpdateWithResponse(this.scope, this.ruleId, this.innerModel(), context).getValue());
        return this;
    }

    GovernanceRuleImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new GovernanceRuleInner();
        this.serviceManager = serviceManager;
        this.ruleId = name;
    }

    @Override
    public GovernanceRuleImpl update() {
        return this;
    }

    @Override
    public GovernanceRule apply() {
        this.innerObject = (GovernanceRuleInner)((Object)this.serviceManager.serviceClient().getGovernanceRules().createOrUpdateWithResponse(this.scope, this.ruleId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public GovernanceRule apply(Context context) {
        this.innerObject = (GovernanceRuleInner)((Object)this.serviceManager.serviceClient().getGovernanceRules().createOrUpdateWithResponse(this.scope, this.ruleId, this.innerModel(), context).getValue());
        return this;
    }

    GovernanceRuleImpl(GovernanceRuleInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.scope = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "scope");
        this.ruleId = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "ruleId");
    }

    @Override
    public GovernanceRule refresh() {
        this.innerObject = (GovernanceRuleInner)((Object)this.serviceManager.serviceClient().getGovernanceRules().getWithResponse(this.scope, this.ruleId, Context.NONE).getValue());
        return this;
    }

    @Override
    public GovernanceRule refresh(Context context) {
        this.innerObject = (GovernanceRuleInner)((Object)this.serviceManager.serviceClient().getGovernanceRules().getWithResponse(this.scope, this.ruleId, context).getValue());
        return this;
    }

    @Override
    public void execute() {
        this.serviceManager.governanceRules().execute(this.scope, this.ruleId);
    }

    @Override
    public void execute(ExecuteGovernanceRuleParams executeGovernanceRuleParams, Context context) {
        this.serviceManager.governanceRules().execute(this.scope, this.ruleId, executeGovernanceRuleParams, context);
    }

    @Override
    public GovernanceRuleImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public GovernanceRuleImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public GovernanceRuleImpl withRemediationTimeframe(String remediationTimeframe) {
        this.innerModel().withRemediationTimeframe(remediationTimeframe);
        return this;
    }

    @Override
    public GovernanceRuleImpl withIsGracePeriod(Boolean isGracePeriod) {
        this.innerModel().withIsGracePeriod(isGracePeriod);
        return this;
    }

    @Override
    public GovernanceRuleImpl withRulePriority(int rulePriority) {
        this.innerModel().withRulePriority(rulePriority);
        return this;
    }

    @Override
    public GovernanceRuleImpl withIsDisabled(Boolean isDisabled) {
        this.innerModel().withIsDisabled(isDisabled);
        return this;
    }

    @Override
    public GovernanceRuleImpl withRuleType(GovernanceRuleType ruleType) {
        this.innerModel().withRuleType(ruleType);
        return this;
    }

    @Override
    public GovernanceRuleImpl withSourceResourceType(GovernanceRuleSourceResourceType sourceResourceType) {
        this.innerModel().withSourceResourceType(sourceResourceType);
        return this;
    }

    @Override
    public GovernanceRuleImpl withExcludedScopes(List<String> excludedScopes) {
        this.innerModel().withExcludedScopes(excludedScopes);
        return this;
    }

    @Override
    public GovernanceRuleImpl withConditionSets(List<Object> conditionSets) {
        this.innerModel().withConditionSets(conditionSets);
        return this;
    }

    @Override
    public GovernanceRuleImpl withIncludeMemberScopes(Boolean includeMemberScopes) {
        this.innerModel().withIncludeMemberScopes(includeMemberScopes);
        return this;
    }

    @Override
    public GovernanceRuleImpl withOwnerSource(GovernanceRuleOwnerSource ownerSource) {
        this.innerModel().withOwnerSource(ownerSource);
        return this;
    }

    @Override
    public GovernanceRuleImpl withGovernanceEmailNotification(GovernanceRuleEmailNotification governanceEmailNotification) {
        this.innerModel().withGovernanceEmailNotification(governanceEmailNotification);
        return this;
    }

    @Override
    public GovernanceRuleImpl withMetadata(GovernanceRuleMetadata metadata) {
        this.innerModel().withMetadata(metadata);
        return this;
    }
}

