/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.GovernanceRulesClient;
import com.azure.resourcemanager.security.fluent.models.GovernanceRuleInner;
import com.azure.resourcemanager.security.fluent.models.OperationResultAutoGeneratedInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.ExecuteGovernanceRuleParams;
import com.azure.resourcemanager.security.models.GovernanceRuleList;
import com.azure.resourcemanager.security.models.GovernanceRulesOperationResultsResponse;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GovernanceRulesClientImpl
implements GovernanceRulesClient {
    private final GovernanceRulesService service;
    private final SecurityCenterImpl client;

    GovernanceRulesClientImpl(SecurityCenterImpl client) {
        this.service = (GovernanceRulesService)RestProxy.create(GovernanceRulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GovernanceRuleInner>> listSinglePageAsync(String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2022-01-01-preview", scope, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GovernanceRuleList)res.getValue()).value(), ((GovernanceRuleList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GovernanceRuleInner>> listSinglePageAsync(String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2022-01-01-preview", scope, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GovernanceRuleList)res.getValue()).value(), ((GovernanceRuleList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GovernanceRuleInner> listAsync(String scope) {
        return new PagedFlux(() -> this.listSinglePageAsync(scope), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GovernanceRuleInner> listAsync(String scope, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(scope, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GovernanceRuleInner> list(String scope) {
        return new PagedIterable(this.listAsync(scope));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GovernanceRuleInner> list(String scope, Context context) {
        return new PagedIterable(this.listAsync(scope, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GovernanceRuleInner>> getWithResponseAsync(String scope, String ruleId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GovernanceRuleInner>> getWithResponseAsync(String scope, String ruleId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GovernanceRuleInner> getAsync(String scope, String ruleId) {
        return this.getWithResponseAsync(scope, ruleId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GovernanceRuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GovernanceRuleInner> getWithResponse(String scope, String ruleId, Context context) {
        return (Response)this.getWithResponseAsync(scope, ruleId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GovernanceRuleInner get(String scope, String ruleId) {
        return (GovernanceRuleInner)((Object)this.getWithResponse(scope, ruleId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GovernanceRuleInner>> createOrUpdateWithResponseAsync(String scope, String ruleId, GovernanceRuleInner governanceRule) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (governanceRule == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter governanceRule is required and cannot be null."));
        }
        governanceRule.validate();
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, governanceRule, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GovernanceRuleInner>> createOrUpdateWithResponseAsync(String scope, String ruleId, GovernanceRuleInner governanceRule, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (governanceRule == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter governanceRule is required and cannot be null."));
        }
        governanceRule.validate();
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, governanceRule, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GovernanceRuleInner> createOrUpdateAsync(String scope, String ruleId, GovernanceRuleInner governanceRule) {
        return this.createOrUpdateWithResponseAsync(scope, ruleId, governanceRule).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GovernanceRuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GovernanceRuleInner> createOrUpdateWithResponse(String scope, String ruleId, GovernanceRuleInner governanceRule, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(scope, ruleId, governanceRule, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GovernanceRuleInner createOrUpdate(String scope, String ruleId, GovernanceRuleInner governanceRule) {
        return (GovernanceRuleInner)((Object)this.createOrUpdateWithResponse(scope, ruleId, governanceRule, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String scope, String ruleId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String scope, String ruleId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String scope, String ruleId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(scope, ruleId);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String scope, String ruleId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(scope, ruleId, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String scope, String ruleId) {
        return this.beginDeleteAsync(scope, ruleId).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String scope, String ruleId, Context context) {
        return this.beginDeleteAsync(scope, ruleId, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String scope, String ruleId) {
        return this.beginDeleteAsync(scope, ruleId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String scope, String ruleId, Context context) {
        return this.beginDeleteAsync(scope, ruleId, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String scope, String ruleId) {
        this.deleteAsync(scope, ruleId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String scope, String ruleId, Context context) {
        this.deleteAsync(scope, ruleId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> executeWithResponseAsync(String scope, String ruleId, ExecuteGovernanceRuleParams executeGovernanceRuleParams) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (executeGovernanceRuleParams != null) {
            executeGovernanceRuleParams.validate();
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.execute(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, executeGovernanceRuleParams, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> executeWithResponseAsync(String scope, String ruleId, ExecuteGovernanceRuleParams executeGovernanceRuleParams, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (executeGovernanceRuleParams != null) {
            executeGovernanceRuleParams.validate();
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.execute(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, executeGovernanceRuleParams, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginExecuteAsync(String scope, String ruleId, ExecuteGovernanceRuleParams executeGovernanceRuleParams) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.executeWithResponseAsync(scope, ruleId, executeGovernanceRuleParams);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginExecuteAsync(String scope, String ruleId) {
        ExecuteGovernanceRuleParams executeGovernanceRuleParams = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.executeWithResponseAsync(scope, ruleId, executeGovernanceRuleParams);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginExecuteAsync(String scope, String ruleId, ExecuteGovernanceRuleParams executeGovernanceRuleParams, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.executeWithResponseAsync(scope, ruleId, executeGovernanceRuleParams, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginExecute(String scope, String ruleId) {
        ExecuteGovernanceRuleParams executeGovernanceRuleParams = null;
        return this.beginExecuteAsync(scope, ruleId, executeGovernanceRuleParams).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginExecute(String scope, String ruleId, ExecuteGovernanceRuleParams executeGovernanceRuleParams, Context context) {
        return this.beginExecuteAsync(scope, ruleId, executeGovernanceRuleParams, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> executeAsync(String scope, String ruleId, ExecuteGovernanceRuleParams executeGovernanceRuleParams) {
        return this.beginExecuteAsync(scope, ruleId, executeGovernanceRuleParams).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> executeAsync(String scope, String ruleId) {
        ExecuteGovernanceRuleParams executeGovernanceRuleParams = null;
        return this.beginExecuteAsync(scope, ruleId, executeGovernanceRuleParams).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> executeAsync(String scope, String ruleId, ExecuteGovernanceRuleParams executeGovernanceRuleParams, Context context) {
        return this.beginExecuteAsync(scope, ruleId, executeGovernanceRuleParams, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void execute(String scope, String ruleId) {
        ExecuteGovernanceRuleParams executeGovernanceRuleParams = null;
        this.executeAsync(scope, ruleId, executeGovernanceRuleParams).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void execute(String scope, String ruleId, ExecuteGovernanceRuleParams executeGovernanceRuleParams, Context context) {
        this.executeAsync(scope, ruleId, executeGovernanceRuleParams, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GovernanceRulesOperationResultsResponse> operationResultsWithResponseAsync(String scope, String ruleId, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.operationResults(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, operationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GovernanceRulesOperationResultsResponse> operationResultsWithResponseAsync(String scope, String ruleId, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.operationResults(this.client.getEndpoint(), "2022-01-01-preview", scope, ruleId, operationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResultAutoGeneratedInner> operationResultsAsync(String scope, String ruleId, String operationId) {
        return this.operationResultsWithResponseAsync(scope, ruleId, operationId).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GovernanceRulesOperationResultsResponse operationResultsWithResponse(String scope, String ruleId, String operationId, Context context) {
        return (GovernanceRulesOperationResultsResponse)((Object)this.operationResultsWithResponseAsync(scope, ruleId, operationId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResultAutoGeneratedInner operationResults(String scope, String ruleId, String operationId) {
        return this.operationResultsWithResponse(scope, ruleId, operationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GovernanceRuleInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GovernanceRuleList)res.getValue()).value(), ((GovernanceRuleList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GovernanceRuleInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GovernanceRuleList)res.getValue()).value(), ((GovernanceRuleList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterGovern")
    public static interface GovernanceRulesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Security/governanceRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GovernanceRuleList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GovernanceRuleInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @PathParam(value="ruleId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GovernanceRuleInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @PathParam(value="ruleId") String var4, @BodyParam(value="application/json") GovernanceRuleInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @PathParam(value="ruleId") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}/execute")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> execute(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @PathParam(value="ruleId") String var4, @BodyParam(value="application/json") ExecuteGovernanceRuleParams var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}/operationResults/{operationId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<GovernanceRulesOperationResultsResponse> operationResults(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @PathParam(value="ruleId") String var4, @PathParam(value="operationId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GovernanceRuleList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

