/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.InformationProtectionPolicyInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.InformationProtectionPolicy;
import com.azure.resourcemanager.security.models.InformationProtectionPolicyName;
import com.azure.resourcemanager.security.models.InformationType;
import com.azure.resourcemanager.security.models.SensitivityLabel;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class InformationProtectionPolicyImpl
implements InformationProtectionPolicy,
InformationProtectionPolicy.Definition,
InformationProtectionPolicy.Update {
    private InformationProtectionPolicyInner innerObject;
    private final SecurityManager serviceManager;
    private String scope;
    private InformationProtectionPolicyName informationProtectionPolicyName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public OffsetDateTime lastModifiedUtc() {
        return this.innerModel().lastModifiedUtc();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public Map<String, SensitivityLabel> labels() {
        Map<String, SensitivityLabel> inner = this.innerModel().labels();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, InformationType> informationTypes() {
        Map<String, InformationType> inner = this.innerModel().informationTypes();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public InformationProtectionPolicyInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public InformationProtectionPolicyImpl withExistingScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public InformationProtectionPolicy create() {
        this.innerObject = (InformationProtectionPolicyInner)((Object)this.serviceManager.serviceClient().getInformationProtectionPolicies().createOrUpdateWithResponse(this.scope, this.informationProtectionPolicyName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public InformationProtectionPolicy create(Context context) {
        this.innerObject = (InformationProtectionPolicyInner)((Object)this.serviceManager.serviceClient().getInformationProtectionPolicies().createOrUpdateWithResponse(this.scope, this.informationProtectionPolicyName, this.innerModel(), context).getValue());
        return this;
    }

    InformationProtectionPolicyImpl(InformationProtectionPolicyName name, SecurityManager serviceManager) {
        this.innerObject = new InformationProtectionPolicyInner();
        this.serviceManager = serviceManager;
        this.informationProtectionPolicyName = name;
    }

    @Override
    public InformationProtectionPolicyImpl update() {
        return this;
    }

    @Override
    public InformationProtectionPolicy apply() {
        this.innerObject = (InformationProtectionPolicyInner)((Object)this.serviceManager.serviceClient().getInformationProtectionPolicies().createOrUpdateWithResponse(this.scope, this.informationProtectionPolicyName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public InformationProtectionPolicy apply(Context context) {
        this.innerObject = (InformationProtectionPolicyInner)((Object)this.serviceManager.serviceClient().getInformationProtectionPolicies().createOrUpdateWithResponse(this.scope, this.informationProtectionPolicyName, this.innerModel(), context).getValue());
        return this;
    }

    InformationProtectionPolicyImpl(InformationProtectionPolicyInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.scope = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}", "scope");
        this.informationProtectionPolicyName = InformationProtectionPolicyName.fromString(ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}", "informationProtectionPolicyName"));
    }

    @Override
    public InformationProtectionPolicy refresh() {
        this.innerObject = (InformationProtectionPolicyInner)((Object)this.serviceManager.serviceClient().getInformationProtectionPolicies().getWithResponse(this.scope, this.informationProtectionPolicyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public InformationProtectionPolicy refresh(Context context) {
        this.innerObject = (InformationProtectionPolicyInner)((Object)this.serviceManager.serviceClient().getInformationProtectionPolicies().getWithResponse(this.scope, this.informationProtectionPolicyName, context).getValue());
        return this;
    }

    @Override
    public InformationProtectionPolicyImpl withLabels(Map<String, SensitivityLabel> labels) {
        this.innerModel().withLabels(labels);
        return this;
    }

    @Override
    public InformationProtectionPolicyImpl withInformationTypes(Map<String, InformationType> informationTypes) {
        this.innerModel().withInformationTypes(informationTypes);
        return this;
    }
}

