/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.IotSecuritySolutionsClient;
import com.azure.resourcemanager.security.fluent.models.IoTSecuritySolutionModelInner;
import com.azure.resourcemanager.security.implementation.IoTSecuritySolutionModelImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.IoTSecuritySolutionModel;
import com.azure.resourcemanager.security.models.IotSecuritySolutions;

public final class IotSecuritySolutionsImpl
implements IotSecuritySolutions {
    private static final ClientLogger LOGGER = new ClientLogger(IotSecuritySolutionsImpl.class);
    private final IotSecuritySolutionsClient innerClient;
    private final SecurityManager serviceManager;

    public IotSecuritySolutionsImpl(IotSecuritySolutionsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<IoTSecuritySolutionModel> list() {
        PagedIterable<IoTSecuritySolutionModelInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IoTSecuritySolutionModelImpl((IoTSecuritySolutionModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IoTSecuritySolutionModel> list(String filter, Context context) {
        PagedIterable<IoTSecuritySolutionModelInner> inner = this.serviceClient().list(filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IoTSecuritySolutionModelImpl((IoTSecuritySolutionModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IoTSecuritySolutionModel> listByResourceGroup(String resourceGroupName) {
        PagedIterable<IoTSecuritySolutionModelInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IoTSecuritySolutionModelImpl((IoTSecuritySolutionModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IoTSecuritySolutionModel> listByResourceGroup(String resourceGroupName, String filter, Context context) {
        PagedIterable<IoTSecuritySolutionModelInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IoTSecuritySolutionModelImpl((IoTSecuritySolutionModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<IoTSecuritySolutionModel> getByResourceGroupWithResponse(String resourceGroupName, String solutionName, Context context) {
        Response<IoTSecuritySolutionModelInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, solutionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IoTSecuritySolutionModelImpl((IoTSecuritySolutionModelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public IoTSecuritySolutionModel getByResourceGroup(String resourceGroupName, String solutionName) {
        IoTSecuritySolutionModelInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, solutionName);
        if (inner != null) {
            return new IoTSecuritySolutionModelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String solutionName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, solutionName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String solutionName) {
        this.serviceClient().delete(resourceGroupName, solutionName);
    }

    @Override
    public IoTSecuritySolutionModel getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "iotSecuritySolutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'iotSecuritySolutions'.", id)));
        }
        return (IoTSecuritySolutionModel)this.getByResourceGroupWithResponse(resourceGroupName, solutionName, Context.NONE).getValue();
    }

    @Override
    public Response<IoTSecuritySolutionModel> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "iotSecuritySolutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'iotSecuritySolutions'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, solutionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "iotSecuritySolutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'iotSecuritySolutions'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, solutionName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "iotSecuritySolutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'iotSecuritySolutions'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, solutionName, context);
    }

    private IotSecuritySolutionsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public IoTSecuritySolutionModelImpl define(String name) {
        return new IoTSecuritySolutionModelImpl(name, this.manager());
    }
}

