/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.LocationsClient;
import com.azure.resourcemanager.security.fluent.models.AscLocationInner;
import com.azure.resourcemanager.security.implementation.AscLocationImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AscLocation;
import com.azure.resourcemanager.security.models.Locations;

public final class LocationsImpl
implements Locations {
    private static final ClientLogger LOGGER = new ClientLogger(LocationsImpl.class);
    private final LocationsClient innerClient;
    private final SecurityManager serviceManager;

    public LocationsImpl(LocationsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AscLocation> list() {
        PagedIterable<AscLocationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AscLocationImpl((AscLocationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AscLocation> list(Context context) {
        PagedIterable<AscLocationInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AscLocationImpl((AscLocationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AscLocation> getWithResponse(String ascLocation, Context context) {
        Response<AscLocationInner> inner = this.serviceClient().getWithResponse(ascLocation, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AscLocationImpl((AscLocationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AscLocation get(String ascLocation) {
        AscLocationInner inner = this.serviceClient().get(ascLocation);
        if (inner != null) {
            return new AscLocationImpl(inner, this.manager());
        }
        return null;
    }

    private LocationsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

