/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.RegulatoryComplianceAssessmentsClient;
import com.azure.resourcemanager.security.fluent.models.RegulatoryComplianceAssessmentInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.RegulatoryComplianceAssessmentList;
import reactor.core.publisher.Mono;

public final class RegulatoryComplianceAssessmentsClientImpl
implements RegulatoryComplianceAssessmentsClient {
    private final RegulatoryComplianceAssessmentsService service;
    private final SecurityCenterImpl client;

    RegulatoryComplianceAssessmentsClientImpl(SecurityCenterImpl client) {
        this.service = (RegulatoryComplianceAssessmentsService)RestProxy.create(RegulatoryComplianceAssessmentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RegulatoryComplianceAssessmentInner>> listSinglePageAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (regulatoryComplianceStandardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceStandardName is required and cannot be null."));
        }
        if (regulatoryComplianceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceControlName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), regulatoryComplianceStandardName, regulatoryComplianceControlName, filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RegulatoryComplianceAssessmentList)res.getValue()).value(), ((RegulatoryComplianceAssessmentList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RegulatoryComplianceAssessmentInner>> listSinglePageAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (regulatoryComplianceStandardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceStandardName is required and cannot be null."));
        }
        if (regulatoryComplianceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceControlName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), regulatoryComplianceStandardName, regulatoryComplianceControlName, filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RegulatoryComplianceAssessmentList)res.getValue()).value(), ((RegulatoryComplianceAssessmentList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RegulatoryComplianceAssessmentInner> listAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(regulatoryComplianceStandardName, regulatoryComplianceControlName, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RegulatoryComplianceAssessmentInner> listAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName) {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(regulatoryComplianceStandardName, regulatoryComplianceControlName, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RegulatoryComplianceAssessmentInner> listAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(regulatoryComplianceStandardName, regulatoryComplianceControlName, filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RegulatoryComplianceAssessmentInner> list(String regulatoryComplianceStandardName, String regulatoryComplianceControlName) {
        String filter = null;
        return new PagedIterable(this.listAsync(regulatoryComplianceStandardName, regulatoryComplianceControlName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RegulatoryComplianceAssessmentInner> list(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String filter, Context context) {
        return new PagedIterable(this.listAsync(regulatoryComplianceStandardName, regulatoryComplianceControlName, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegulatoryComplianceAssessmentInner>> getWithResponseAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String regulatoryComplianceAssessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (regulatoryComplianceStandardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceStandardName is required and cannot be null."));
        }
        if (regulatoryComplianceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceControlName is required and cannot be null."));
        }
        if (regulatoryComplianceAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceAssessmentName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), regulatoryComplianceStandardName, regulatoryComplianceControlName, regulatoryComplianceAssessmentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegulatoryComplianceAssessmentInner>> getWithResponseAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String regulatoryComplianceAssessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (regulatoryComplianceStandardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceStandardName is required and cannot be null."));
        }
        if (regulatoryComplianceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceControlName is required and cannot be null."));
        }
        if (regulatoryComplianceAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceAssessmentName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), regulatoryComplianceStandardName, regulatoryComplianceControlName, regulatoryComplianceAssessmentName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RegulatoryComplianceAssessmentInner> getAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String regulatoryComplianceAssessmentName) {
        return this.getWithResponseAsync(regulatoryComplianceStandardName, regulatoryComplianceControlName, regulatoryComplianceAssessmentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RegulatoryComplianceAssessmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RegulatoryComplianceAssessmentInner> getWithResponse(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String regulatoryComplianceAssessmentName, Context context) {
        return (Response)this.getWithResponseAsync(regulatoryComplianceStandardName, regulatoryComplianceControlName, regulatoryComplianceAssessmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RegulatoryComplianceAssessmentInner get(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String regulatoryComplianceAssessmentName) {
        return (RegulatoryComplianceAssessmentInner)((Object)this.getWithResponse(regulatoryComplianceStandardName, regulatoryComplianceControlName, regulatoryComplianceAssessmentName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RegulatoryComplianceAssessmentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RegulatoryComplianceAssessmentList)res.getValue()).value(), ((RegulatoryComplianceAssessmentList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RegulatoryComplianceAssessmentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RegulatoryComplianceAssessmentList)res.getValue()).value(), ((RegulatoryComplianceAssessmentList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterRegula")
    public static interface RegulatoryComplianceAssessmentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/regulatoryComplianceStandards/{regulatoryComplianceStandardName}/regulatoryComplianceControls/{regulatoryComplianceControlName}/regulatoryComplianceAssessments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RegulatoryComplianceAssessmentList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="regulatoryComplianceStandardName") String var4, @PathParam(value="regulatoryComplianceControlName") String var5, @QueryParam(value="$filter") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/regulatoryComplianceStandards/{regulatoryComplianceStandardName}/regulatoryComplianceControls/{regulatoryComplianceControlName}/regulatoryComplianceAssessments/{regulatoryComplianceAssessmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RegulatoryComplianceAssessmentInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="regulatoryComplianceStandardName") String var4, @PathParam(value="regulatoryComplianceControlName") String var5, @PathParam(value="regulatoryComplianceAssessmentName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RegulatoryComplianceAssessmentList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

